/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamIndex;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EventHeaderTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MqttSubscribeOutputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        EventStreamIndex eventStreamIndex = EventStreamIndex.of((Model)model);
        return model.shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream((Shape)shape, SubscribeTrait.class)).flatMap(pair -> this.validateOperation(model, (OperationShape)pair.getLeft(), eventStreamIndex).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateOperation(Model model, OperationShape shape, EventStreamIndex eventStreamIndex) {
        EventStreamInfo info = eventStreamIndex.getOutputInfo((ToShapeId)shape).orElse(null);
        if (info == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (info.hasInitialMessage()) {
            events.add(this.error((Shape)shape, (FromSourceLocation)shape.getTrait(SubscribeTrait.class).get(), "Operations marked with the `smithy.mqtt#subscribe` trait must not utilize event streams with initial responses in their output structure."));
        }
        this.getOutputEvents(info, model).flatMap(target -> target.getAllMembers().values().stream().filter(member -> member.hasTrait(EventHeaderTrait.class))).map(member -> this.danger((Shape)shape, "This member is used as part of an MQTT event stream event, and MQTT event streams do not support the eventHeader trait.")).forEach(events::add);
        return events;
    }

    private Stream<StructureShape> getOutputEvents(final EventStreamInfo info, final Model model) {
        return (Stream)info.getEventStreamTarget().accept((ShapeVisitor)new ShapeVisitor.Default<Stream<StructureShape>>(){

            public Stream<StructureShape> getDefault(Shape shape) {
                return Stream.empty();
            }

            public Stream<StructureShape> unionShape(UnionShape shape) {
                return shape.getAllMembers().entrySet().stream().flatMap(member -> OptionalUtils.stream(model.getShape(((MemberShape)member.getValue()).getTarget()).flatMap(Shape::asStructureShape)));
            }

            public Stream<StructureShape> structureShape(StructureShape shape) {
                return Stream.of(info.getEventStreamTarget().asStructureShape().get());
            }
        });
    }
}

