/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.mqtt.traits.TopicSyntaxException;

public final class Topic {
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    private final String topic;
    private final List<Level> levels;

    private Topic(String topic, List<Level> levels) {
        this.topic = topic;
        this.levels = Collections.unmodifiableList(levels);
    }

    public static Topic parse(String topic) {
        return Topic.parse(TopicRule.TOPIC, topic);
    }

    public static Topic parse(TopicRule rule, String topic) {
        ArrayList<Level> levels = new ArrayList<Level>();
        HashSet<String> labels = new HashSet<String>();
        if (topic.isEmpty()) {
            throw new TopicSyntaxException("Topics and topic filters may not be empty");
        }
        boolean hasFullWildcard = false;
        for (String level : topic.split("/", -1)) {
            if (hasFullWildcard) {
                throw new TopicSyntaxException(String.format("A full wildcard must be the last segment in a topic filter. Found `%s` in `%s`", level, topic));
            }
            if (level.contains("#") || level.contains("+")) {
                if (rule == TopicRule.TOPIC) {
                    throw new TopicSyntaxException(String.format("Wildcard levels are not allowed in MQTT topics. Found `%s` in `%s`", level, topic));
                }
                if (level.length() > 1) {
                    throw new TopicSyntaxException(String.format("A wildcard must be the entire topic segment. Found `%s` in `%s`", level, topic));
                }
                if (level.equals("#")) {
                    hasFullWildcard = true;
                }
            }
            if (level.startsWith("{") && level.endsWith("}")) {
                String label = level.substring(1, level.length() - 1);
                if (!LABEL_PATTERN.matcher(label).matches()) {
                    throw new TopicSyntaxException(String.format("Invalid topic label name `%s` found in `%s`", label, topic));
                }
                if (labels.contains(label)) {
                    throw new TopicSyntaxException(String.format("Duplicate topic label `%s` found in `%s`", label, topic));
                }
                labels.add(label);
                levels.add(new Level(label, true));
                continue;
            }
            if (level.contains("{") || level.contains("}")) {
                throw new TopicSyntaxException(String.format("Topic labels must span an entire level. Found `%s` in `%s`", level, topic));
            }
            levels.add(new Level(level, false));
        }
        return new Topic(topic, levels);
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public List<Level> getLabels() {
        return this.levels.stream().filter(Level::isLabel).collect(Collectors.toList());
    }

    public boolean hasLabel(String label) {
        for (Level level : this.levels) {
            if (!level.isLabel || !level.value.equals(label)) continue;
            return true;
        }
        return false;
    }

    public boolean conflictsWith(Topic other) {
        int minSize = Math.min(this.levels.size(), other.levels.size());
        for (int i = 0; i < minSize; ++i) {
            Level thisLevel = this.levels.get(i);
            Level otherLevel = other.levels.get(i);
            String thisValue = thisLevel.getContent();
            String otherValue = otherLevel.getContent();
            if (thisValue.equals("#") || otherValue.equals("#")) {
                return true;
            }
            if (thisValue.equals("+") || otherValue.equals("+")) continue;
            if (!(thisLevel.isLabel() || otherLevel.isLabel() || thisValue.equals(otherValue))) {
                return false;
            }
            if (thisLevel.isLabel() == otherLevel.isLabel()) continue;
            return false;
        }
        return this.levels.size() == other.levels.size();
    }

    public String toString() {
        return this.topic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        return this.topic.equals(((Topic)o).topic);
    }

    public int hashCode() {
        return this.topic.hashCode();
    }

    public static enum TopicRule {
        TOPIC,
        FILTER;

    }

    public static final class Level {
        private String value;
        private boolean isLabel;

        public Level(String value, boolean isLabel) {
            this.isLabel = isLabel;
            this.value = value;
        }

        public Level(String value) {
            this(value, false);
        }

        public String getContent() {
            return this.value;
        }

        public boolean isLabel() {
            return this.isLabel;
        }

        public String toString() {
            return this.isLabel ? "{" + this.value + "}" : this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Level)) {
                return false;
            }
            Level level = (Level)o;
            return this.isLabel == level.isLabel && this.value.equals(level.value);
        }

        public int hashCode() {
            return Objects.hash(this.isLabel, this.value);
        }
    }
}

