/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.Topic;

public final class TopicBinding<T extends Trait> {
    private final OperationShape operation;
    private final T mqttTrait;
    private final Topic topic;
    private final Shape payloadShape;
    private final StructureShape input;

    TopicBinding(OperationShape operation, T mqttTrait, Topic topic, Shape payloadShape, StructureShape input) {
        this.operation = operation;
        this.mqttTrait = mqttTrait;
        this.topic = topic;
        this.payloadShape = payloadShape;
        this.input = input;
    }

    public static Optional<? extends Trait> getOperationMqttTrait(Shape operation) {
        if (operation.hasTrait(PublishTrait.ID)) {
            return operation.getTrait(PublishTrait.class);
        }
        if (operation.hasTrait(SubscribeTrait.ID)) {
            return operation.getTrait(SubscribeTrait.class);
        }
        return Optional.empty();
    }

    public T getMqttTrait() {
        return this.mqttTrait;
    }

    public OperationShape getOperation() {
        return this.operation;
    }

    public Topic getTopic() {
        return this.topic;
    }

    @Deprecated
    public Optional<StructureShape> getInput() {
        return Optional.ofNullable(this.input);
    }

    public StructureShape getInputShape() {
        return this.input;
    }

    public Optional<Shape> getPayloadShape() {
        return Optional.ofNullable(this.payloadShape);
    }

    public boolean conflictsWith(TopicBinding<?> other) {
        ShapeId targetB;
        if (!this.getTopic().conflictsWith(other.getTopic())) {
            return false;
        }
        if (this.payloadShape == null) {
            return other.payloadShape != null;
        }
        if (other.payloadShape == null) {
            return true;
        }
        ShapeId targetA = this.getPayloadShape().get().getId();
        return !targetA.equals((Object)(targetB = other.getPayloadShape().get().getId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicBinding)) {
            return false;
        }
        TopicBinding that = (TopicBinding)o;
        return this.operation.equals((Object)that.operation) && this.getInput().equals(that.getInput()) && this.mqttTrait.equals(that.mqttTrait) && this.getTopic().equals(that.getTopic()) && this.getPayloadShape().equals(that.getPayloadShape());
    }

    public int hashCode() {
        return Objects.hash(this.operation.getId(), this.mqttTrait.toShapeId());
    }

    public String toString() {
        return "TopicBinding{operation=" + this.operation.getId() + ", input=" + this.getInput().map(Shape::getId).map(ShapeId::toString).orElse("null") + ", mqttTrait=" + this.mqttTrait.toShapeId() + ", topic=" + this.topic + ", payloadShape=" + String.valueOf(this.payloadShape) + '}';
    }
}

