/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.Topic;
import software.amazon.smithy.mqtt.traits.TopicLabelTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class MqttTopicLabelValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        OperationIndex index = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapes()) {
            TopicCollection topics = MqttTopicLabelValidator.createTopics(operation);
            if (topics == null) continue;
            events.addAll(this.validateMqtt(index, topics));
        }
        return events;
    }

    private static TopicCollection createTopics(OperationShape shape) {
        if (shape.hasTrait(SubscribeTrait.class)) {
            SubscribeTrait trait = (SubscribeTrait)shape.expectTrait(SubscribeTrait.class);
            List<Topic> bindings = Collections.singletonList(trait.getTopic());
            return new TopicCollection(shape, (Trait)trait, bindings);
        }
        if (shape.hasTrait(PublishTrait.class)) {
            PublishTrait trait = (PublishTrait)shape.expectTrait(PublishTrait.class);
            List<Topic> bindings = Collections.singletonList(trait.getTopic());
            return new TopicCollection(shape, (Trait)trait, bindings);
        }
        return null;
    }

    private List<ValidationEvent> validateMqtt(OperationIndex index, TopicCollection topics) {
        Set<String> labels = topics.getLabels();
        StructureShape input = index.expectInputShape((ToShapeId)topics.operation);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : input.getAllMembers().values()) {
            if (!member.hasTrait(TopicLabelTrait.class)) continue;
            if (labels.contains(member.getMemberName())) {
                labels.remove(member.getMemberName());
                continue;
            }
            events.add(this.error((Shape)member, (FromSourceLocation)member.expectTrait(TopicLabelTrait.class), String.format("This member is marked with the `smithy.mqtt#topicLabel` trait, but when this member is used as part of the input of the `%s` operation, a corresponding label cannot be found in the `%s` trait", topics.operation.getId(), Trait.getIdiomaticTraitName((ToShapeId)topics.trait.toShapeId()))));
        }
        if (!labels.isEmpty()) {
            events.add(this.error((Shape)topics.operation, (FromSourceLocation)topics.trait, String.format("The `%s` trait contains the following topic labels that could not be found in the input structure of the operation or were not marked with the `smithy.mqtt#topicLabel` trait: [%s]", Trait.getIdiomaticTraitName((ToShapeId)topics.trait.toShapeId()), ValidationUtils.tickedList(labels))));
        }
        return events;
    }

    private static final class TopicCollection {
        final List<Topic> topics;
        final OperationShape operation;
        final Trait trait;

        TopicCollection(OperationShape operation, Trait trait, List<Topic> topics) {
            this.operation = operation;
            this.trait = trait;
            this.topics = topics;
        }

        Set<String> getLabels() {
            return this.topics.stream().flatMap(topic -> topic.getLabels().stream().map(Topic.Level::getContent)).collect(Collectors.toSet());
        }
    }
}

