/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MqttPublishInputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape shape : model.getOperationShapesWithTrait(PublishTrait.class)) {
            this.validateOperation(model, shape, operationIndex.expectInputShape((ToShapeId)shape), events);
        }
        return events;
    }

    private void validateOperation(Model model, OperationShape operation, StructureShape input, List<ValidationEvent> events) {
        for (MemberShape member : input.getAllMembers().values()) {
            if (!StreamingTrait.isEventStream((Model)model, (MemberShape)member)) continue;
            events.add(this.error((Shape)member, String.format("The input of `smithy.mqtt#publish` operations cannot contain event streams, and this member is used as part of the input of the `%s` operation.", operation.getId())));
        }
    }
}

