/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.TopicLabelTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MqttSubscribeInputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape shape : model.getOperationShapesWithTrait(SubscribeTrait.class)) {
            this.validateOperation(shape, operationIndex.expectInputShape((ToShapeId)shape), events);
        }
        return events;
    }

    private void validateOperation(OperationShape operation, StructureShape input, List<ValidationEvent> events) {
        for (MemberShape member : input.getAllMembers().values()) {
            if (member.hasTrait(TopicLabelTrait.class)) continue;
            events.add(this.error((Shape)member, String.format("All input members of an operation marked with the `smithy.mqtt#subscribe` trait must be marked with the `smithy.mqtt#topicLabel` trait, and this member is used as part of the input of the `%s` operation.", operation.getId())));
        }
    }
}

