/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.ResolvedTopicIndex;
import software.amazon.smithy.mqtt.traits.TopicBinding;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MqttTopicConflictValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ResolvedTopicIndex bindingIndex = (ResolvedTopicIndex)model.getKnowledge(ResolvedTopicIndex.class);
        return bindingIndex.topicBindings().map(binding -> Pair.of((Object)binding, bindingIndex.topicBindings().filter(other -> other.conflictsWith((TopicBinding<?>)binding)).collect(Collectors.toList()))).filter(conflictingPair -> !((List)conflictingPair.getRight()).isEmpty()).map(conflictingPair -> this.invalidBindings((TopicBinding)conflictingPair.getLeft(), (List)conflictingPair.getRight())).collect(Collectors.toList());
    }

    private ValidationEvent invalidBindings(TopicBinding<? extends Trait> binding, List<TopicBinding<?>> conflicts) {
        String payloadShape = binding.getPayloadShape().map(shape -> shape.getId().toString()).orElse("N/A");
        String conflictingStrings = conflicts.stream().filter(b -> !b.equals(binding)).map(this::createConflictingBindingDescriptor).sorted().collect(Collectors.joining(", "));
        String message = String.format("This shape resolves to an MQTT topic `%s` as part of the `%s` operation, and its payload of `%s` conflicts with other topic payloads: [%s]", binding.getTopic(), binding.getOperation().getId(), payloadShape, conflictingStrings);
        return this.error((Shape)binding.getOperation(), (FromSourceLocation)binding.getMqttTrait(), message);
    }

    private String createConflictingBindingDescriptor(TopicBinding<? extends Trait> binding) {
        return String.format("`%s` trait payload %s of `%s`", Trait.getIdiomaticTraitName((ToShapeId)binding.getMqttTrait().toShapeId()), binding.getPayloadShape().map(Shape::getId).map(id -> "`" + id + "`").orElse("N/A"), binding.getOperation().getId());
    }
}

