/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.TopicLabelTrait;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MqttSubscribeInputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(OperationShape.class).filter(shape -> shape.hasTrait(SubscribeTrait.class)).flatMap(shape -> this.validateOperation(model, (OperationShape)shape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateOperation(Model model, OperationShape operation) {
        return OptionalUtils.stream(operation.getInput().flatMap(arg_0 -> ((Model)model).getShape(arg_0)).flatMap(Shape::asStructureShape)).flatMap(input -> input.getAllMembers().values().stream().filter(member -> !member.hasTrait(TopicLabelTrait.class)).map(member -> this.error((Shape)member, String.format("All input members of an operation marked with the `smithy.mqtt#subscribe` trait must be marked with the `smithy.mqtt#topicLabel` trait, and this member is used as part of the input of the `%s` operation.", operation.getId()))));
    }
}

