/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamIndex;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.TopicBinding;

public final class ResolvedTopicIndex
implements KnowledgeIndex {
    private final Map<ShapeId, TopicBinding<PublishTrait>> publishBindings = new HashMap<ShapeId, TopicBinding<PublishTrait>>();
    private final Map<ShapeId, TopicBinding<SubscribeTrait>> subscribeBindings = new HashMap<ShapeId, TopicBinding<SubscribeTrait>>();
    private final Map<ShapeId, EventStreamInfo> subscribeInfo = new HashMap<ShapeId, EventStreamInfo>();

    public ResolvedTopicIndex(Model model) {
        EventStreamIndex eventStreamIndex = (EventStreamIndex)model.getKnowledge(EventStreamIndex.class);
        OperationIndex operationIndex = (OperationIndex)model.getKnowledge(OperationIndex.class);
        model.shapes(OperationShape.class).forEach(operation -> {
            if (operation.hasTrait(PublishTrait.class)) {
                PublishTrait trait = (PublishTrait)((Object)((Object)operation.getTrait(PublishTrait.class).get()));
                this.createPublishBindings(operationIndex, (OperationShape)operation, trait);
            } else if (operation.hasTrait(SubscribeTrait.class)) {
                SubscribeTrait trait = (SubscribeTrait)((Object)((Object)operation.getTrait(SubscribeTrait.class).get()));
                StructureShape input = operationIndex.getInput((ToShapeId)operation).orElse(null);
                this.createSubscribeBinding(input, eventStreamIndex, (OperationShape)operation, trait);
            }
        });
    }

    public List<TopicBinding<? extends Trait>> getOperationBindings(ToShapeId operation) {
        ShapeId id = operation.toShapeId();
        return this.topicBindings().filter(binding -> binding.getOperation().getId().equals((Object)id)).collect(Collectors.toList());
    }

    public Stream<TopicBinding<? extends Trait>> topicBindings() {
        return Stream.concat(this.publishBindings.values().stream(), this.subscribeBindings.values().stream());
    }

    public Optional<TopicBinding<PublishTrait>> getPublishBinding(ToShapeId operation) {
        return Optional.ofNullable(this.publishBindings.get(operation.toShapeId()));
    }

    public Optional<TopicBinding<SubscribeTrait>> getSubscribeBinding(ToShapeId operation) {
        return Optional.ofNullable(this.subscribeBindings.get(operation.toShapeId()));
    }

    public Optional<EventStreamInfo> getSubcribeEventStreamInfo(ToShapeId operation) {
        return Optional.ofNullable(this.subscribeInfo.get(operation.toShapeId()));
    }

    private void createPublishBindings(OperationIndex operationIndex, OperationShape operation, PublishTrait trait) {
        TopicBinding topicBinding = operationIndex.getInput((ToShapeId)operation).map(input -> new TopicBinding<PublishTrait>(operation, trait, trait.getTopic(), (Shape)input, (StructureShape)input)).orElseGet(() -> new TopicBinding<PublishTrait>(operation, trait, trait.getTopic(), null, null));
        this.publishBindings.put(operation.getId(), topicBinding);
    }

    private void createSubscribeBinding(StructureShape input, EventStreamIndex eventStreamIndex, OperationShape operation, SubscribeTrait trait) {
        EventStreamInfo outputInfo = eventStreamIndex.getOutputInfo((ToShapeId)operation).orElse(null);
        if (outputInfo != null) {
            TopicBinding<SubscribeTrait> binding = new TopicBinding<SubscribeTrait>(operation, trait, trait.getTopic(), outputInfo.getEventStreamTarget(), input);
            this.subscribeBindings.put(operation.getId(), binding);
            this.subscribeInfo.put(operation.getId(), outputInfo);
        }
    }
}

