/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.mqtt.traits.SubscribeTrait;
import software.amazon.smithy.mqtt.traits.TopicBinding;
import software.amazon.smithy.utils.OptionalUtils;

public final class MqttUnsupportedErrorsValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(OperationShape.class).filter(shape -> !shape.getErrors().isEmpty()).flatMap(shape -> OptionalUtils.stream(this.validateOperation((OperationShape)shape))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateOperation(OperationShape shape) {
        return TopicBinding.getOperationMqttTrait((Shape)shape).filter(trait -> trait instanceof PublishTrait || trait instanceof SubscribeTrait).map(trait -> this.danger((Shape)shape, (FromSourceLocation)trait, String.format("Operations marked with the `%s` trait do not support errors.", Trait.getIdiomaticTraitName((ToShapeId)trait.toShapeId()))));
    }
}

