/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.mqtt.traits.validators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.EventStreamTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.mqtt.traits.PublishTrait;
import software.amazon.smithy.utils.OptionalUtils;

public class MqttPublishInputValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        return index.shapes(OperationShape.class).filter(shape -> shape.hasTrait(PublishTrait.class)).flatMap(shape -> this.validateOperation(index, (OperationShape)shape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateOperation(ShapeIndex index, OperationShape operation) {
        return OptionalUtils.stream(operation.getInput().flatMap(arg_0 -> ((ShapeIndex)index).getShape(arg_0)).flatMap(Shape::asStructureShape)).flatMap(input -> input.getAllMembers().values().stream().filter(member -> member.hasTrait(EventStreamTrait.class)).map(member -> this.error((Shape)member, String.format("The input of `smithy.mqtt#publish` operations cannot contain event streams, and this member is used as part of the input of the `%s` operation.", operation.getId()))));
    }
}

