/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceShape
extends EntityShape
implements ToSmithyBuilder<ServiceShape> {
    private final String version;
    private final Map<ShapeId, String> rename;

    private ServiceShape(Builder builder) {
        super(builder);
        this.version = (String)SmithyBuilder.requiredState((String)"version", (Object)builder.version);
        this.rename = MapUtils.orderedCopyOf((Map)builder.rename);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)ServiceShape.builder().from(this)).version(this.version);
        this.getOperations().forEach(builder::addOperation);
        this.getResources().forEach(builder::addResource);
        builder.rename(this.rename);
        return builder;
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.serviceShape(this);
    }

    @Override
    public Optional<ServiceShape> asServiceShape() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        ServiceShape o = (ServiceShape)other;
        return this.version.equals(o.version) && this.rename.equals(o.rename);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<ShapeId, String> getRename() {
        return this.rename;
    }

    public String getContextualName(ToShapeId shape) {
        ShapeId id = shape.toShapeId();
        return this.rename.getOrDefault(id, id.getName());
    }

    public static final class Builder
    extends EntityShape.Builder<Builder, ServiceShape> {
        private String version;
        private final Map<ShapeId, String> rename = new TreeMap<ShapeId, String>();

        public ServiceShape build() {
            return new ServiceShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.SERVICE;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder clearRename() {
            this.rename.clear();
            return this;
        }

        public Builder rename(Map<ShapeId, String> rename) {
            this.clearRename();
            rename.forEach(this::putRename);
            return this;
        }

        public Builder putRename(ShapeId from, String to) {
            this.rename.put(Objects.requireNonNull(from), Objects.requireNonNull(to));
            return this;
        }

        public Builder removeRename(ToShapeId from) {
            this.rename.remove(from.toShapeId());
            return this;
        }
    }
}

