/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.List;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.node.FilteredPlugin;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

final class StringEnumPlugin
extends FilteredPlugin<StringShape, StringNode> {
    StringEnumPlugin() {
        super(StringShape.class, StringNode.class);
    }

    @Override
    protected void check(StringShape shape, StringNode node, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
        shape.getTrait(EnumTrait.class).ifPresent(trait -> {
            List<String> values = trait.getEnumDefinitionValues();
            if (!values.contains(node.getValue())) {
                emitter.accept(node, String.format("String value provided for `%s` must be one of the following values: %s", shape.getId(), ValidationUtils.tickedList(values)));
            }
        });
    }
}

