/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.node.BlobLengthPlugin;
import software.amazon.smithy.model.validation.node.CollectionLengthPlugin;
import software.amazon.smithy.model.validation.node.IdRefPlugin;
import software.amazon.smithy.model.validation.node.MapLengthPlugin;
import software.amazon.smithy.model.validation.node.PatternTraitPlugin;
import software.amazon.smithy.model.validation.node.RangeTraitPlugin;
import software.amazon.smithy.model.validation.node.StringEnumPlugin;
import software.amazon.smithy.model.validation.node.StringLengthPlugin;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public interface NodeValidatorPlugin {
    public void apply(Shape var1, Node var2, Context var3, BiConsumer<FromSourceLocation, String> var4);

    public static List<NodeValidatorPlugin> getBuiltins() {
        return ListUtils.of((Object[])new NodeValidatorPlugin[]{new BlobLengthPlugin(), new CollectionLengthPlugin(), new IdRefPlugin(), new MapLengthPlugin(), new PatternTraitPlugin(), new RangeTraitPlugin(), new StringEnumPlugin(), new StringLengthPlugin()});
    }

    @SmithyInternalApi
    public static final class Context {
        private final Model model;
        private final Map<Selector, Set<Shape>> selectorResults = new LinkedHashMap<Selector, Set<Shape>>(51, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<Selector, Set<Shape>> eldest) {
                return this.size() > 50;
            }
        };

        public Context(Model model) {
            this.model = model;
        }

        public Model model() {
            return this.model;
        }

        public Set<Shape> select(Selector selector) {
            return this.selectorResults.computeIfAbsent(selector, s -> s.select(this.model));
        }
    }
}

