/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class CollectionLengthPlugin
extends MemberAndShapeTraitPlugin<CollectionShape, ArrayNode, LengthTrait> {
    CollectionLengthPlugin() {
        super(CollectionShape.class, ArrayNode.class, LengthTrait.class);
    }

    @Override
    protected void check(Shape shape, LengthTrait trait, ArrayNode node, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
        trait.getMin().ifPresent(min -> {
            if ((long)node.size() < min) {
                emitter.accept(node, String.format("Value provided for `%s` must have at least %d elements, but the provided value only has %d elements", shape.getId(), min, node.size()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.size() > max) {
                emitter.accept(node, String.format("Value provided for `%s` must have no more than %d elements, but the provided value has %d elements", shape.getId(), max, node.size()));
            }
        });
    }
}

