/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;

@FunctionalInterface
public interface TraitFactory {
    public Optional<Trait> createTrait(ShapeId var1, ShapeId var2, Node var3);

    public static TraitFactory createServiceFactory(Iterable<TraitService> services) {
        HashMap serviceMap = new HashMap();
        services.forEach(service -> serviceMap.put(service.getShapeId(), service));
        return (name, target, value) -> Optional.ofNullable(serviceMap.get(name)).map(provider -> provider.createTrait(target, value));
    }

    public static TraitFactory createServiceFactory() {
        return TraitFactory.createServiceFactory(ServiceLoader.load(TraitService.class));
    }

    public static TraitFactory createServiceFactory(ClassLoader classLoader) {
        return TraitFactory.createServiceFactory(ServiceLoader.load(TraitService.class, classLoader));
    }
}

