/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.selector.AttributeComparator;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class ScopedAttributeSelector
implements InternalSelector {
    private final List<String> path;
    private final List<Assertion> assertions;

    ScopedAttributeSelector(List<String> path, List<Assertion> assertions) {
        this.path = path;
        this.assertions = assertions;
    }

    @Override
    public boolean push(Context context, Shape shape, InternalSelector.Receiver next) {
        if (this.matchesAssertions(shape, context.getVars())) {
            return next.apply(context, shape);
        }
        return true;
    }

    private boolean matchesAssertions(Shape shape, Map<String, Set<Shape>> vars) {
        AttributeValue scope = AttributeValue.shape(shape, vars).getPath(this.path);
        if (!scope.isPresent()) {
            return false;
        }
        for (AttributeValue attributeValue : scope.getFlattenedValues()) {
            if (!this.compareWithScope(attributeValue)) continue;
            return true;
        }
        return false;
    }

    private boolean compareWithScope(AttributeValue scope) {
        for (Assertion assertion : this.assertions) {
            AttributeValue lhs = assertion.lhs.create(scope);
            for (ScopedFactory factory : assertion.rhs) {
                AttributeValue rhs = factory.create(scope);
                if (assertion.comparator.compare(lhs, rhs, assertion.caseInsensitive)) continue;
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    static interface ScopedFactory {
        public AttributeValue create(AttributeValue var1);
    }

    static final class Assertion {
        private final ScopedFactory lhs;
        private final AttributeComparator comparator;
        private final List<ScopedFactory> rhs;
        private final boolean caseInsensitive;

        Assertion(ScopedFactory lhs, AttributeComparator comparator, List<ScopedFactory> rhs, boolean caseInsensitive) {
            this.lhs = lhs;
            this.comparator = comparator;
            this.rhs = rhs;
            this.caseInsensitive = caseInsensitive;
        }
    }
}

