/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.utils.SetUtils;

public class NullableIndex
implements KnowledgeIndex {
    private static final Set<ShapeType> INHERENTLY_BOXED = SetUtils.of((Object[])new ShapeType[]{ShapeType.STRING, ShapeType.BLOB, ShapeType.TIMESTAMP, ShapeType.BIG_DECIMAL, ShapeType.BIG_INTEGER, ShapeType.LIST, ShapeType.SET, ShapeType.MAP, ShapeType.STRUCTURE, ShapeType.UNION, ShapeType.DOCUMENT});
    private final Set<ShapeId> nullableShapes = new HashSet<ShapeId>();

    public NullableIndex(Model model) {
        for (ShapeType type : INHERENTLY_BOXED) {
            model.shapes(type.getShapeClass()).forEach(shape -> this.nullableShapes.add(shape.getId()));
        }
        for (Shape shape2 : model.getShapesWithTrait(BoxTrait.class)) {
            if (shape2.isMemberShape()) continue;
            this.nullableShapes.add(shape2.getId());
        }
        for (MemberShape member : model.getMemberShapes()) {
            if (!NullableIndex.isMemberNullable(model, member)) continue;
            this.nullableShapes.add(member.getId());
        }
    }

    public static NullableIndex of(Model model) {
        return model.getKnowledge(NullableIndex.class, NullableIndex::new);
    }

    private static boolean isMemberNullable(Model model, MemberShape member) {
        Shape container = model.getShape(member.getContainer()).orElse(null);
        if (container == null) {
            return false;
        }
        switch (container.getType()) {
            case STRUCTURE: {
                return member.hasTrait(BoxTrait.class) || model.getShape(member.getTarget()).filter(NullableIndex::isShapeBoxed).isPresent();
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    private static boolean isShapeBoxed(Shape shape) {
        return INHERENTLY_BOXED.contains((Object)shape.getType()) || shape.hasTrait(BoxTrait.class);
    }

    public final boolean isNullable(ToShapeId shape) {
        return this.nullableShapes.contains(shape.toShapeId());
    }
}

