/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

public final class HttpPrefixHeadersTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(HttpPrefixHeadersTrait.class)) {
            shape.asMemberShape().ifPresent(member -> model.getShape(member.getContainer()).flatMap(Shape::asStructureShape).ifPresent(structure -> events.addAll(this.validateMember((StructureShape)structure, (MemberShape)member, member.expectTrait(HttpPrefixHeadersTrait.class)))));
        }
        return events;
    }

    private List<ValidationEvent> validateMember(StructureShape structure, MemberShape member, HttpPrefixHeadersTrait trait) {
        String prefix = trait.getValue().toLowerCase(Locale.US);
        return structure.getAllMembers().values().stream().flatMap(m -> Trait.flatMapStream(m, HttpHeaderTrait.class)).map(pair -> Pair.of((Object)pair.getLeft(), (Object)((HttpHeaderTrait)pair.getRight()).getValue().toLowerCase(Locale.US))).filter(pair -> ((String)pair.getRight()).startsWith(prefix)).map(pair -> this.error((Shape)pair.getLeft(), String.format("`httpHeader` binding of `%s` conflicts with the `httpPrefixHeaders` binding of `%s` to `%s`. `httpHeader` bindings must not case-insensitively start with any `httpPrefixHeaders` bindings.", pair.getRight(), member.getId(), prefix))).collect(Collectors.toList());
    }
}

