/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Objects;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;

public final class NeighborProviderIndex
implements KnowledgeIndex {
    private final NeighborProvider provider;
    private final NeighborProvider providerWithTraits;
    private final NeighborProvider reversed;
    private final WeakReference<Model> model;
    private volatile NeighborProvider reversedWithTraits;

    public NeighborProviderIndex(Model model) {
        this.provider = NeighborProvider.precomputed(model);
        this.reversed = NeighborProvider.reverse(model, this.provider);
        this.providerWithTraits = NeighborProvider.cached(NeighborProvider.withTraitRelationships(model, this.provider));
        this.model = new WeakReference<Model>(model);
    }

    public static NeighborProviderIndex of(Model model) {
        return model.getKnowledge(NeighborProviderIndex.class, NeighborProviderIndex::new);
    }

    public NeighborProvider getProvider() {
        return this.provider;
    }

    public NeighborProvider getProviderWithTraitRelationships() {
        return this.providerWithTraits;
    }

    public NeighborProvider getReverseProvider() {
        return this.reversed;
    }

    public NeighborProvider getReverseProviderWithTraitRelationships() {
        NeighborProvider result = this.reversedWithTraits;
        if (result == null) {
            this.reversedWithTraits = result = NeighborProvider.reverse(this.getOrThrowModel(), this.providerWithTraits);
        }
        return result;
    }

    private Model getOrThrowModel() {
        return Objects.requireNonNull((Model)this.model.get(), "Model was destroyed before using this knowledge index");
    }
}

