/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;

final class NodeDiff {
    NodeDiff() {
    }

    static List<String> diff(ToNode actual, ToNode expected) {
        return new NodeDiff().findDifferences(actual.toNode(), expected.toNode(), "").sorted().collect(Collectors.toList());
    }

    private Stream<String> findDifferences(Node actual, Node expected, String prefix) {
        if (actual.equals(expected)) {
            return Stream.empty();
        }
        if (!actual.getType().equals((Object)expected.getType())) {
            return Stream.of(String.format("[%s]: Expected node of type `%s` but found node of type `%s`.%n%nExpected: %s%n%n Found: %s", new Object[]{prefix, expected.getType(), actual.getType(), NodeDiff.nodeToJson(expected, true), NodeDiff.nodeToJson(actual, true)}));
        }
        switch (actual.getType()) {
            case OBJECT: {
                return this.findDifferences(actual.expectObjectNode(), expected.expectObjectNode(), prefix);
            }
            case ARRAY: {
                return this.findDifferences(actual.expectArrayNode(), expected.expectArrayNode(), prefix);
            }
        }
        return Stream.of(String.format("[%s]: Expected `%s` but found `%s`", prefix, NodeDiff.nodeToJson(expected, false), NodeDiff.nodeToJson(actual, false)));
    }

    private Stream<String> findDifferences(ObjectNode actual, ObjectNode expected, String prefix) {
        ArrayList<String> differences = new ArrayList<String>();
        Set actualKeys = actual.getMembers().keySet().stream().map(StringNode::getValue).collect(Collectors.toSet());
        Set expectedKeys = expected.getMembers().keySet().stream().map(StringNode::getValue).collect(Collectors.toSet());
        HashSet extraKeys = new HashSet(actualKeys);
        extraKeys.removeAll(expectedKeys);
        for (Object extraKey : extraKeys) {
            differences.add(String.format("[%s]: Extra key `%s` encountered with content: %s", prefix, extraKey, NodeDiff.nodeToJson(actual.expectMember((String)extraKey), true)));
        }
        HashSet missingKeys = new HashSet(expectedKeys);
        missingKeys.removeAll(actualKeys);
        for (String missingKey : missingKeys) {
            differences.add(String.format("[%s]: Expected key `%s` not present.", prefix, missingKey));
        }
        HashSet sharedKeys = new HashSet(actualKeys);
        sharedKeys.retainAll(expectedKeys);
        return Stream.concat(differences.stream(), sharedKeys.stream().flatMap(key -> this.findDifferences(actual.expectMember((String)key), expected.expectMember((String)key), String.format("%s/%s", prefix, key.replace("^", "^^").replace("/", "^/")))));
    }

    private Stream<String> findDifferences(ArrayNode actual, ArrayNode expected, String prefix) {
        int i2;
        ArrayList<String> differences = new ArrayList<String>();
        List<Node> actualElements = actual.getElements();
        List<Node> expectedElements = expected.getElements();
        for (i2 = expectedElements.size(); i2 < actualElements.size(); ++i2) {
            differences.add(String.format("[%s]: Extra element encountered in list at position %d: %s", prefix, i2, NodeDiff.nodeToJson(actualElements.get(i2), true)));
        }
        for (i2 = actualElements.size(); i2 < expectedElements.size(); ++i2) {
            differences.add(String.format("[%s]: Expected element (position %d) not encountered in list: %s", prefix, i2, NodeDiff.nodeToJson(expectedElements.get(i2), true)));
        }
        return Stream.concat(differences.stream(), IntStream.range(0, Math.min(actualElements.size(), expectedElements.size())).boxed().flatMap(i -> this.findDifferences((Node)actualElements.get((int)i), (Node)expectedElements.get((int)i), String.format("%s[%d]", prefix, i))));
    }

    private static String nodeToJson(Node node, boolean prettyPrint) {
        return prettyPrint ? Node.prettyPrintJson(node) : Node.printJson(node);
    }
}

