/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.ShapeModifier;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ApplyResourceBasedTargets
implements ShapeModifier {
    private final ShapeId resourceId;
    private List<ValidationEvent> events;

    ApplyResourceBasedTargets(ShapeId resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public void modifyMember(AbstractShapeBuilder<?, ?> shapeBuilder, MemberShape.Builder memberBuilder, Function<ShapeId, Map<ShapeId, Trait>> unclaimedTraits, Function<ShapeId, Shape> shapeMap) {
        if (memberBuilder.getTarget() != null) {
            return;
        }
        Shape fromShape = shapeMap.apply(this.resourceId);
        if (fromShape == null) {
            throw new SourceException("Cannot apply resource to elided member " + memberBuilder.getId() + ": " + this.resourceId + " not found", memberBuilder);
        }
        if (!fromShape.isResourceShape()) {
            this.fromShapeIsNotResource(memberBuilder, fromShape);
        } else {
            ResourceShape resource = fromShape.asResourceShape().get();
            String name = memberBuilder.getId().getMember().get();
            if (resource.getIdentifiers().containsKey(name)) {
                memberBuilder.target(resource.getIdentifiers().get(name));
            }
            if (resource.getProperties().containsKey(name)) {
                memberBuilder.target(resource.getProperties().get(name));
            }
        }
    }

    private void fromShapeIsNotResource(MemberShape.Builder memberBuilder, Shape fromShape) {
        String message = String.format("The target of the `for` production must be a resource shape, but found a %s shape: %s", new Object[]{fromShape.getType(), this.resourceId});
        ValidationEvent event = ValidationEvent.builder().id("Model").severity(Severity.ERROR).shapeId(memberBuilder.getId()).sourceLocation(memberBuilder.getSourceLocation()).message(message).build();
        if (this.events == null) {
            this.events = new ArrayList<ValidationEvent>(1);
        }
        this.events.add(event);
    }

    @Override
    public List<ValidationEvent> getEvents() {
        return this.events == null ? Collections.emptyList() : this.events;
    }
}

