/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class TopDownIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Set<ResourceShape>> resources = new HashMap<ShapeId, Set<ResourceShape>>();
    private final Map<ShapeId, Set<OperationShape>> operations = new HashMap<ShapeId, Set<OperationShape>>();
    private final Map<ShapeId, Set<ResourceShape>> sortedResources = new HashMap<ShapeId, Set<ResourceShape>>();
    private final Map<ShapeId, Set<OperationShape>> sortedOperations = new HashMap<ShapeId, Set<OperationShape>>();

    public TopDownIndex(Model model) {
        NeighborProvider provider = NeighborProviderIndex.of(model).getProvider();
        Walker walker = new Walker(provider);
        Predicate<Relationship> filter = rel -> {
            RelationshipType type = rel.getRelationshipType();
            return type == RelationshipType.RESOURCE || type.isOperationBinding();
        };
        for (ResourceShape resource : model.getResourceShapes()) {
            this.findContained(resource.getId(), walker.walkShapes(resource, filter));
        }
        for (ServiceShape service : model.getServiceShapes()) {
            this.findContained(service.getId(), walker.walkShapes(service, filter));
        }
    }

    public static TopDownIndex of(Model model) {
        return model.getKnowledge(TopDownIndex.class, TopDownIndex::new);
    }

    private void findContained(ShapeId container, Collection<Shape> shapes) {
        LinkedHashSet<ResourceShape> containedResources = new LinkedHashSet<ResourceShape>();
        LinkedHashSet<OperationShape> containedOperations = new LinkedHashSet<OperationShape>();
        for (Shape shape : shapes) {
            if (shape.getId().equals(container)) continue;
            if (shape instanceof ResourceShape) {
                containedResources.add((ResourceShape)shape);
                continue;
            }
            if (!(shape instanceof OperationShape)) continue;
            containedOperations.add((OperationShape)shape);
        }
        this.operations.put(container, Collections.unmodifiableSet(containedOperations));
        this.resources.put(container, Collections.unmodifiableSet(containedResources));
        this.sortedOperations.put(container, Collections.unmodifiableSortedSet(new TreeSet(containedOperations)));
        this.sortedResources.put(container, Collections.unmodifiableSortedSet(new TreeSet(containedResources)));
    }

    public Set<OperationShape> getContainedOperations(ToShapeId entity) {
        return this.getContainedOperations(entity, true);
    }

    public Set<OperationShape> getContainedOperations(ToShapeId entity, boolean sorted) {
        if (sorted) {
            return this.sortedOperations.getOrDefault(entity.toShapeId(), Collections.emptySet());
        }
        return this.operations.getOrDefault(entity.toShapeId(), Collections.emptySet());
    }

    public Set<ResourceShape> getContainedResources(ToShapeId entity) {
        return this.getContainedResources(entity, true);
    }

    public Set<ResourceShape> getContainedResources(ToShapeId entity, boolean sorted) {
        if (sorted) {
            return this.sortedResources.getOrDefault(entity.toShapeId(), Collections.emptySet());
        }
        return this.resources.getOrDefault(entity.toShapeId(), Collections.emptySet());
    }
}

