/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;

public class HttpBindingTraitIgnoredValidator
extends AbstractValidator {
    private static final List<ShapeId> IGNORED_OUTSIDE_INPUT = ListUtils.of((Object[])new ShapeId[]{HttpLabelTrait.ID, HttpQueryParamsTrait.ID, HttpQueryTrait.ID});
    private static final List<ShapeId> IGNORED_OUTSIDE_OUTPUT = ListUtils.of((Object)HttpResponseCodeTrait.ID);
    private static final List<ShapeId> HTTP_MEMBER_BINDING_TRAITS = ListUtils.of((Object[])new ShapeId[]{HttpHeaderTrait.ID, HttpLabelTrait.ID, HttpPayloadTrait.ID, HttpPrefixHeadersTrait.ID, HttpQueryParamsTrait.ID, HttpQueryTrait.ID, HttpResponseCodeTrait.ID});

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NeighborProvider reverse = NeighborProviderIndex.of(model).getReverseProvider();
        for (MemberShape memberShape : model.getMemberShapes()) {
            Shape container = model.expectShape(memberShape.getContainer());
            if (!container.isStructureShape() || container.hasTrait(MixinTrait.ID)) continue;
            HashMap<ShapeId, Trait> traits = new HashMap<ShapeId, Trait>();
            for (Map.Entry<ShapeId, Trait> traitEntry : memberShape.getAllTraits().entrySet()) {
                if (!HTTP_MEMBER_BINDING_TRAITS.contains(traitEntry.getKey())) continue;
                traits.put(traitEntry.getKey(), traitEntry.getValue());
            }
            if (traits.isEmpty()) continue;
            events.addAll(this.checkRelationships(container.asStructureShape().get(), memberShape, traits, reverse));
        }
        return events;
    }

    private List<ValidationEvent> checkRelationships(StructureShape containerShape, MemberShape memberShape, Map<ShapeId, Trait> traits, NeighborProvider reverse) {
        HashSet<ShapeId> ignoredOutsideInputTraits = new HashSet<ShapeId>(traits.keySet());
        ignoredOutsideInputTraits.retainAll(IGNORED_OUTSIDE_INPUT);
        HashSet<ShapeId> ignoredOutsideOutputTraits = new HashSet<ShapeId>(traits.keySet());
        ignoredOutsideOutputTraits.retainAll(IGNORED_OUTSIDE_OUTPUT);
        TreeMap<RelationshipType, List<ShapeId>> ignoredRelationships = new TreeMap<RelationshipType, List<ShapeId>>();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<Relationship> relationships = reverse.getNeighbors(containerShape);
        int checkedRelationshipCount = relationships.size();
        for (Relationship relationship : relationships) {
            if (relationship.getRelationshipType() == RelationshipType.MEMBER_CONTAINER) {
                --checkedRelationshipCount;
                continue;
            }
            if (relationship.getRelationshipType() != RelationshipType.INPUT && !ignoredOutsideInputTraits.isEmpty()) {
                ignoredRelationships.merge(relationship.getRelationshipType(), ListUtils.of((Object)relationship.getShape().getId()), this::mergeShapeIdLists);
                continue;
            }
            if (relationship.getRelationshipType() != RelationshipType.OUTPUT && !ignoredOutsideOutputTraits.isEmpty()) {
                ignoredRelationships.merge(relationship.getRelationshipType(), ListUtils.of((Object)relationship.getShape().getId()), this::mergeShapeIdLists);
                continue;
            }
            if (relationship.getRelationshipType() == RelationshipType.INPUT || relationship.getRelationshipType() == RelationshipType.OUTPUT || relationship.getRelationshipType() == RelationshipType.ERROR) continue;
            ignoredRelationships.merge(relationship.getRelationshipType(), ListUtils.of((Object)relationship.getShape().getId()), this::mergeShapeIdLists);
        }
        if (!ignoredRelationships.isEmpty()) {
            Trait trait;
            if (!ignoredOutsideInputTraits.isEmpty()) {
                trait = traits.get(ignoredOutsideInputTraits.iterator().next());
                events.add(this.emit("Input", memberShape, trait, checkedRelationshipCount, ignoredRelationships));
            } else if (!ignoredOutsideOutputTraits.isEmpty()) {
                trait = traits.get(ignoredOutsideOutputTraits.iterator().next());
                events.add(this.emit("Output", memberShape, trait, checkedRelationshipCount, ignoredRelationships));
            } else {
                trait = traits.get(traits.keySet().iterator().next());
                events.add(this.emit("TopLevel", memberShape, trait, checkedRelationshipCount, ignoredRelationships));
            }
        }
        return events;
    }

    private List<ShapeId> mergeShapeIdLists(List<ShapeId> shapeIds1, List<ShapeId> shapeIds2) {
        ArrayList<ShapeId> shapeIds = new ArrayList<ShapeId>();
        shapeIds.addAll(shapeIds1);
        shapeIds.addAll(shapeIds2);
        return shapeIds;
    }

    private ValidationEvent emit(String type, MemberShape memberShape, Trait trait, int checkedRelationshipCount, Map<RelationshipType, List<ShapeId>> ignoredRelationships) {
        String mixedIn = memberShape.getMixins().isEmpty() ? "" : " mixed in";
        String message = "The `%s` trait applied to this%s member is ";
        message = checkedRelationshipCount == ignoredRelationships.size() ? message + "ignored in all contexts." : message + "ignored in some contexts: " + this.formatIgnoredRelationships(ignoredRelationships);
        return this.warning((Shape)memberShape, trait, String.format(message, Trait.getIdiomaticTraitName(trait), mixedIn), type);
    }

    private String formatIgnoredRelationships(Map<RelationshipType, List<ShapeId>> ignoredRelationships) {
        ArrayList<String> relationshipTypeBindings = new ArrayList<String>();
        for (Map.Entry<RelationshipType, List<ShapeId>> ignoredRelationshipType : ignoredRelationships.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder(ignoredRelationshipType.getKey().toString().toLowerCase(Locale.US).replace("_", " "));
            TreeSet<String> bindings = new TreeSet<String>();
            for (ShapeId binding : ignoredRelationshipType.getValue()) {
                bindings.add(binding.toString());
            }
            stringBuilder.append(": [").append(String.join((CharSequence)", ", bindings)).append("]");
            relationshipTypeBindings.add(stringBuilder.toString());
        }
        return "{" + String.join((CharSequence)", ", relationshipTypeBindings) + "}";
    }
}

