/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class RemoveInvalidDefaults {
    private static final Logger LOGGER = Logger.getLogger(RemoveInvalidDefaults.class.getName());

    RemoveInvalidDefaults() {
    }

    Model transform(ModelTransformer transformer, Model model) {
        HashSet<Shape> invalidDefaults = new HashSet<Shape>();
        HashSet<Shape> updates = new HashSet<Shape>();
        for (Shape shape : model.getShapesWithTrait(DefaultTrait.class)) {
            shape.getMemberTrait(model, RangeTrait.class).ifPresent(rangeTrait -> {
                DefaultTrait defaultTrait = shape.expectTrait(DefaultTrait.class);
                if (defaultTrait.toNode().isNumberNode()) {
                    defaultTrait.toNode().expectNumberNode().asBigDecimal().ifPresent(value -> {
                        if (rangeTrait.getMin().filter(min -> value.compareTo((BigDecimal)min) < 0).isPresent() || rangeTrait.getMin().filter(max -> value.compareTo((BigDecimal)max) > 0).isPresent()) {
                            invalidDefaults.add(shape);
                        }
                    });
                }
            });
        }
        for (Shape shape : invalidDefaults) {
            updates.add(this.modify(shape, model, invalidDefaults));
        }
        return transformer.replaceShapes(model, updates);
    }

    private Shape modify(Shape shape, Model model, Set<Shape> otherShapes) {
        MemberShape member;
        boolean targetHasDefault;
        RangeTrait rangeTrait = shape.getMemberTrait(model, RangeTrait.class).get();
        LOGGER.info(() -> "Removing default trait from " + shape.getId() + " because of an incompatible range trait: " + Node.printJson(rangeTrait.toNode()));
        if (shape.isMemberShape() && (targetHasDefault = model.getShape((member = shape.asMemberShape().get()).getTarget()).filter(target -> !otherShapes.contains(target) && target.hasTrait(DefaultTrait.ID)).isPresent())) {
            return ((MemberShape.Builder)member.toBuilder().addTrait(new DefaultTrait(Node.nullNode()))).build();
        }
        return (Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).removeTrait(DefaultTrait.ID).build();
    }
}

