/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class AddClientOptional {
    private final boolean applyWhenNoDefaultValue;

    AddClientOptional(boolean applyWhenNoDefaultValue) {
        this.applyWhenNoDefaultValue = applyWhenNoDefaultValue;
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.mapShapes(model, shape -> {
            boolean isEffectivelyClientOptional;
            if (!(shape instanceof MemberShape)) {
                return shape;
            }
            MemberShape member = (MemberShape)shape;
            if (member.hasTrait(ClientOptionalTrait.ID)) {
                return member;
            }
            Shape container = model.expectShape(member.getContainer());
            Shape target = model.expectShape(member.getTarget());
            boolean hasInputTrait = container.hasTrait(InputTrait.ID);
            boolean targetsShapeWithNoZeroValue = target.isStructureShape() || target.isUnionShape();
            boolean bl = isEffectivelyClientOptional = hasInputTrait || !member.hasTrait(RequiredTrait.ID) && !member.hasTrait(DefaultTrait.ID) || targetsShapeWithNoZeroValue && this.applyWhenNoDefaultValue;
            if (isEffectivelyClientOptional) {
                return ((MemberShape.Builder)member.toBuilder().addTrait(new ClientOptionalTrait(member.getSourceLocation()))).build();
            }
            return member;
        });
    }
}

