/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoadOperation;
import software.amazon.smithy.model.loader.LoaderShapeMap;
import software.amazon.smithy.model.loader.LoaderTraitMap;
import software.amazon.smithy.model.loader.MetadataContainer;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventDecorator;

final class LoadOperationProcessor
implements Consumer<LoadOperation> {
    private final List<ValidationEvent> events;
    private final MetadataContainer metadata = new MetadataContainer();
    private final LoaderShapeMap shapeMap;
    private final LoaderTraitMap traitMap;
    private final Queue<LoadOperation.ForwardReference> forwardReferences = new ArrayDeque<LoadOperation.ForwardReference>();
    private final LoadOperation.Visitor visitor;
    private final Model prelude;
    private final Map<String, Version> modelVersions = new HashMap<String, Version>();

    LoadOperationProcessor(TraitFactory traitFactory, Model prelude, boolean allowUnknownTraits, final Consumer<ValidationEvent> validationEventListener, final ValidationEventDecorator decorator) {
        this.events = new ArrayList<ValidationEvent>(){

            @Override
            public boolean add(ValidationEvent e) {
                e = decorator.decorate(e);
                validationEventListener.accept(e);
                return super.add(e);
            }

            @Override
            public boolean addAll(Collection<? extends ValidationEvent> validationEvents) {
                this.ensureCapacity(this.size() + validationEvents.size());
                for (ValidationEvent validationEvent : validationEvents) {
                    this.add(validationEvent);
                }
                return true;
            }
        };
        this.prelude = prelude;
        this.shapeMap = new LoaderShapeMap(prelude, this.events);
        this.traitMap = new LoaderTraitMap(traitFactory, this.events, allowUnknownTraits);
        this.visitor = new LoadOperation.Visitor(){

            @Override
            public void putMetadata(LoadOperation.PutMetadata operation) {
                LoadOperationProcessor.this.metadata.putMetadata(operation.key, operation.value, LoadOperationProcessor.this.events);
            }

            @Override
            public void applyTrait(LoadOperation.ApplyTrait operation) {
                LoadOperationProcessor.this.traitMap.add(operation);
                LoadOperationProcessor.this.shapeMap.moveCreatedShapeToOperations(operation.target, LoadOperationProcessor.this);
            }

            @Override
            public void defineShape(LoadOperation.DefineShape operation) {
                LoadOperationProcessor.this.shapeMap.add(operation);
                LoadOperationProcessor.this.shapeMap.moveCreatedShapeToOperations(operation.toShapeId(), LoadOperationProcessor.this);
            }

            @Override
            public void forwardReference(LoadOperation.ForwardReference operation) {
                LoadOperationProcessor.this.forwardReferences.add(operation);
            }

            @Override
            public void event(LoadOperation.Event operation) {
                LoadOperationProcessor.this.events.add(operation.event);
            }

            @Override
            public void modelVersion(LoadOperation.ModelVersion operation) {
                if (!operation.getSourceLocation().equals(SourceLocation.none()) && !operation.getSourceLocation().getFilename().isEmpty()) {
                    LoadOperationProcessor.this.modelVersions.put(operation.getSourceLocation().getFilename(), operation.version);
                }
            }
        };
    }

    @Override
    public void accept(LoadOperation operation) {
        operation.accept(this.visitor);
    }

    void putCreatedShape(Shape shape) {
        this.shapeMap.add(shape, this);
    }

    Version getShapeVersion(Shape shape) {
        SourceLocation location = shape.getSourceLocation();
        if (location == SourceLocation.NONE || location.getFilename().isEmpty()) {
            return this.shapeMap.getShapeVersion(shape.getId());
        }
        return this.modelVersions.getOrDefault(location.getFilename(), Version.UNKNOWN);
    }

    Model buildModel() {
        Model.Builder modelBuilder = Model.builder();
        modelBuilder.metadata(this.metadata.getData());
        this.resolveForwardReferences();
        ArrayList<ShapeId> undefinedTraits = new ArrayList<ShapeId>();
        this.traitMap.applyTraitsToNonMixinsInShapeMap(this.shapeMap, undefinedTraits);
        this.shapeMap.buildShapesAndClaimMixinTraits(modelBuilder, this.traitMap::claimTraitsForShape);
        this.traitMap.emitUnclaimedTraits();
        this.validateTraitWithTraitDefinition(undefinedTraits, modelBuilder);
        if (this.prelude != null) {
            modelBuilder.addShapes(this.prelude);
        }
        return modelBuilder.build();
    }

    List<ValidationEvent> events() {
        return this.events;
    }

    private void validateTraitWithTraitDefinition(List<ShapeId> undefiedTraits, Model.Builder modelBuilder) {
        Map<ShapeId, Shape> shapes = modelBuilder.getCurrentShapes();
        for (ShapeId traitId : undefiedTraits) {
            Shape traitShape;
            if (!shapes.containsKey(traitId) || (traitShape = shapes.get(traitId)).hasTrait(TraitDefinition.ID)) continue;
            this.events.add(ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(traitShape.getSourceLocation()).shapeId(traitId).message(String.format("Shape `%s` cannot be applied as a trait. If this is a custom trait, please add `@trait` to this shape.", traitId)).build());
        }
    }

    private void resolveForwardReferences() {
        while (!this.forwardReferences.isEmpty()) {
            LoadOperation.ForwardReference reference = this.forwardReferences.poll();
            if (reference.namespace == null) {
                ShapeId absolute = ShapeId.fromOptionalNamespace("smithy.api", reference.name);
                this.resolveReference(reference, absolute, this.shapeMap.getShapeType(absolute));
                continue;
            }
            this.detectAndEmitForwardReference(reference);
        }
    }

    private void resolveReference(LoadOperation.ForwardReference reference, ShapeId id, ShapeType type) {
        ValidationEvent event = reference.resolve(id, type);
        if (event != null) {
            this.events.add(event);
        }
    }

    private void detectAndEmitForwardReference(LoadOperation.ForwardReference reference) {
        Objects.requireNonNull(reference.namespace);
        ShapeId inNamespace = ShapeId.fromOptionalNamespace(reference.namespace, reference.name);
        ShapeType inNamespaceType = this.shapeMap.getShapeType(inNamespace);
        if (inNamespaceType != null) {
            this.resolveReference(reference, inNamespace, inNamespaceType);
        } else {
            ShapeId preludeId = ShapeId.fromOptionalNamespace("smithy.api", reference.name);
            if (this.prelude != null && this.prelude.getShapeIds().contains(preludeId)) {
                this.resolveReference(reference, preludeId, this.prelude.expectShape(preludeId).getType());
            } else {
                this.resolveReference(reference, inNamespace, null);
            }
        }
    }
}

