/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public final class TopologicalShapeSort {
    private final Map<ShapeId, Set<ShapeId>> forwardDependencies = new HashMap<ShapeId, Set<ShapeId>>();
    private final Map<ShapeId, Set<ShapeId>> reverseDependencies = new HashMap<ShapeId, Set<ShapeId>>();
    private final Deque<ShapeId> satisfiedShapes;

    public TopologicalShapeSort() {
        this(100);
    }

    TopologicalShapeSort(int ensureCapacity) {
        this.satisfiedShapes = new ArrayDeque<ShapeId>(ensureCapacity);
    }

    public void enqueue(Shape shape) {
        this.enqueue(shape.getId(), shape.getMixins());
    }

    public void enqueue(ShapeId shape, Collection<ShapeId> dependencies) {
        if (dependencies.isEmpty()) {
            this.satisfiedShapes.offer(shape);
            Set<ShapeId> previousDependencies = this.forwardDependencies.remove(shape);
            if (previousDependencies != null) {
                for (ShapeId dependency : previousDependencies) {
                    this.reverseDependencies.get(dependency).remove(shape);
                }
            }
        } else {
            for (ShapeId dependency : dependencies) {
                this.reverseDependencies.computeIfAbsent(dependency, unused -> new HashSet()).add(shape);
            }
            this.forwardDependencies.put(shape, new HashSet<ShapeId>(dependencies));
            if (this.satisfiedShapes.contains(shape)) {
                this.satisfiedShapes.remove(shape);
            }
        }
    }

    public List<ShapeId> dequeueSortedShapes() {
        ArrayList<ShapeId> result = new ArrayList<ShapeId>(this.satisfiedShapes.size() + this.forwardDependencies.size());
        while (!this.satisfiedShapes.isEmpty()) {
            ShapeId current = this.satisfiedShapes.poll();
            this.forwardDependencies.remove(current);
            result.add(current);
            for (ShapeId dependent : this.reverseDependencies.getOrDefault(current, Collections.emptySet())) {
                Set<ShapeId> dependentDependencies = this.forwardDependencies.get(dependent);
                dependentDependencies.remove(current);
                if (!dependentDependencies.isEmpty()) continue;
                this.satisfiedShapes.offer(dependent);
            }
        }
        this.reverseDependencies.clear();
        if (!this.forwardDependencies.isEmpty()) {
            throw new CycleException(new TreeSet<ShapeId>(this.forwardDependencies.keySet()), result);
        }
        return result;
    }

    public static final class CycleException
    extends RuntimeException {
        private final Set<ShapeId> unresolved;
        private final List<ShapeId> resolved;

        public CycleException(Set<ShapeId> unresolved, List<ShapeId> resolved) {
            super("Mixin cycles detected among " + unresolved);
            this.unresolved = unresolved;
            this.resolved = resolved;
        }

        public Set<ShapeId> getUnresolved() {
            return this.unresolved;
        }

        public List<ShapeId> getResolved() {
            return this.resolved;
        }
    }
}

