/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class JsonNameValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashSet<ShapeId> visitedContainers = new HashSet<ShapeId>();
        for (MemberShape member : model.getMemberShapesWithTrait(JsonNameTrait.class)) {
            if (!visitedContainers.add(member.getContainer())) continue;
            this.validateMembersOfContainer(model.expectShape(member.getContainer()), events);
        }
        return events;
    }

    private void validateMembersOfContainer(Shape container, List<ValidationEvent> events) {
        TreeMap<String, Set> memberMappings = new TreeMap<String, Set>();
        for (MemberShape memberShape : container.members()) {
            String jsonName = memberShape.getTrait(JsonNameTrait.class).map(StringTrait::getValue).orElseGet(memberShape::getMemberName);
            memberMappings.computeIfAbsent(jsonName, n -> new TreeSet()).add(memberShape);
        }
        for (Map.Entry entry : memberMappings.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            events.add(this.error(container, String.format("This shape contains members with conflicting JSON names that resolve to '%s': %s", entry.getKey(), ((Set)entry.getValue()).stream().map(MemberShape::getMemberName).collect(Collectors.joining(", ")))));
        }
    }
}

