/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.List;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ProtocolDefinitionTrait
extends AbstractTrait
implements ToSmithyBuilder<ProtocolDefinitionTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#protocolDefinition");
    private final List<ShapeId> traits;
    private final boolean noInlineDocumentSupport;

    public ProtocolDefinitionTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.traits = (List)builder.traits.copy();
        this.noInlineDocumentSupport = builder.noInlineDocumentSupport;
    }

    public List<ShapeId> getTraits() {
        return this.traits;
    }

    public boolean getNoInlineDocumentSupport() {
        return this.noInlineDocumentSupport;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.sourceLocation(this.getSourceLocation());
        if (!this.traits.isEmpty()) {
            ArrayNode ids = this.traits.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect());
            builder.withMember("traits", ids);
            if (this.noInlineDocumentSupport) {
                builder.withMember("noInlineDocumentSupport", true);
            }
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return ((Builder)ProtocolDefinitionTrait.builder().sourceLocation(this.getSourceLocation())).traits(this.traits).noInlineDocumentSupport(this.noInlineDocumentSupport);
    }

    public static final class Builder
    extends AbstractTraitBuilder<ProtocolDefinitionTrait, Builder> {
        private final BuilderRef<List<ShapeId>> traits = BuilderRef.forList();
        private boolean noInlineDocumentSupport;

        public ProtocolDefinitionTrait build() {
            return new ProtocolDefinitionTrait(this);
        }

        public Builder traits(List<ShapeId> traits) {
            this.traits.clear();
            ((List)this.traits.get()).addAll(traits);
            return this;
        }

        public Builder addTrait(ShapeId trait) {
            ((List)this.traits.get()).add(trait);
            return this;
        }

        public Builder noInlineDocumentSupport(boolean noInlineDocumentSupport) {
            this.noInlineDocumentSupport = noInlineDocumentSupport;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public ProtocolDefinitionTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)ProtocolDefinitionTrait.builder().sourceLocation(value);
            value.expectObjectNode().getArrayMember("traits", ShapeId::fromNode, builder::traits).getBooleanMember("noInlineDocumentSupport", builder::noInlineDocumentSupport);
            ProtocolDefinitionTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

