/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

final class PatternTraitPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, PatternTrait> {
    PatternTraitPlugin() {
        super(StringShape.class, StringNode.class, PatternTrait.class);
    }

    @Override
    protected void check(Shape shape, PatternTrait trait, StringNode node, NodeValidatorPlugin.Context context, NodeValidatorPlugin.Emitter emitter) {
        if (!trait.getPattern().matcher(node.getValue()).find()) {
            emitter.accept(node, this.getSeverity(context), String.format("String value provided for `%s` must match regular expression: %s", shape.getId(), trait.getPattern().pattern()));
        }
    }

    private Severity getSeverity(NodeValidatorPlugin.Context context) {
        return context.hasFeature(NodeValidationVisitor.Feature.ALLOW_CONSTRAINT_ERRORS) ? Severity.WARNING : Severity.ERROR;
    }
}

