/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformException;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

final class RemoveShapes {
    private static final Logger LOGGER = Logger.getLogger(RemoveShapes.class.getName());
    private final Collection<? extends Shape> toRemove;
    private final List<ModelTransformerPlugin> plugins;

    RemoveShapes(Collection<? extends Shape> toRemove, List<ModelTransformerPlugin> plugins) {
        this.toRemove = toRemove;
        this.plugins = plugins;
    }

    Model transform(ModelTransformer transformer, Model model) {
        Model.Builder builder = model.toBuilder();
        HashSet<Shape> removed = new HashSet<Shape>(this.toRemove);
        for (Shape shape : this.toRemove) {
            this.validateShapeCopiedFromMixin(model, shape);
            builder.removeShape(shape.getId());
            removed.addAll(shape.members());
        }
        Model result = builder.build();
        for (ModelTransformerPlugin plugin : this.plugins) {
            result = plugin.onRemove(transformer, removed, result);
        }
        return result;
    }

    private void validateShapeCopiedFromMixin(Model model, Shape shape) {
        if (!shape.isMemberShape()) {
            return;
        }
        MemberShape memberShape = shape.asMemberShape().get();
        Shape container = model.getShape(memberShape.getContainer()).orElseThrow(() -> new ModelTransformException(String.format("Cannot find the container shape for member `%s`.", memberShape.getMemberName())));
        for (ShapeId mixinId : container.getMixins()) {
            Shape mixinShape = model.expectShape(mixinId);
            if (!mixinShape.getMemberNames().contains(memberShape.getMemberName()) || this.toRemove.contains(mixinShape)) continue;
            LOGGER.warning(String.format("Removing mixed in member `%s` from mixin shape `%s` in `%s` will result in an inconsistent model.", memberShape.getMemberName(), mixinShape.getId(), container.getId().getName()));
        }
    }
}

