/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NamedMemberUtils;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.traits.InternalTrait;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.model.traits.synthetic.SyntheticEnumTrait;
import software.amazon.smithy.utils.BuilderRef;

public final class EnumShape
extends StringShape {
    private static final Pattern CONVERTABLE_VALUE = Pattern.compile("^[a-zA-Z-_.:/\\s]+[a-zA-Z_0-9-.:/\\s]*$");
    private static final Logger LOGGER = Logger.getLogger(EnumShape.class.getName());
    private final Map<String, MemberShape> members;
    private volatile Map<String, String> enumValues;

    private EnumShape(Builder builder) {
        super(builder);
        this.members = NamedMemberUtils.computeMixinMembers(builder.getMixins(), (BuilderRef<Map<String, MemberShape>>)builder.members, this.getId(), this.getSourceLocation());
        this.validateMemberShapeIds();
        if (this.members.size() < 1) {
            throw new SourceException("enum shapes must have at least one member", this.getSourceLocation());
        }
    }

    private EnumShape(Builder builder, Map<String, MemberShape> members) {
        super(builder);
        this.members = members;
        this.validateMemberShapeIds();
        if (members.size() < 1) {
            throw new SourceException("enum shapes must have at least one member", this.getSourceLocation());
        }
    }

    public Map<String, String> getEnumValues() {
        if (this.enumValues == null) {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>(this.members.size());
            for (MemberShape member : this.members()) {
                values.put(member.getMemberName(), member.expectTrait(EnumValueTrait.class).expectStringValue());
            }
            this.enumValues = Collections.unmodifiableMap(values);
        }
        return this.enumValues;
    }

    @Override
    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    @Override
    public Optional<Trait> findTrait(ShapeId id) {
        if (id.equals(EnumTrait.ID)) {
            return super.findTrait(SyntheticEnumTrait.ID);
        }
        return super.findTrait(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return this.updateBuilder(EnumShape.builder());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.enumShape(this);
    }

    @Override
    public Optional<EnumShape> asEnumShape() {
        return Optional.of(this);
    }

    public static Optional<EnumShape> fromStringShape(StringShape shape, boolean synthesizeNames) {
        if (shape.isEnumShape()) {
            return Optional.of((EnumShape)shape);
        }
        if (!shape.hasTrait(EnumTrait.ID)) {
            return Optional.empty();
        }
        StringShape stringWithoutEnumTrait = ((StringShape.Builder)shape.toBuilder().removeTrait(EnumTrait.ID)).build();
        Builder enumBuilder = EnumShape.builder();
        stringWithoutEnumTrait.updateBuilder(enumBuilder);
        try {
            return Optional.of(enumBuilder.setMembersFromEnumTrait(shape.expectTrait(EnumTrait.class), synthesizeNames).build());
        }
        catch (IllegalStateException e) {
            LOGGER.info(String.format("Unable to convert `%s` to an enum: %s", shape.getId(), e));
            return Optional.empty();
        }
    }

    public static Optional<EnumShape> fromStringShape(StringShape shape) {
        return EnumShape.fromStringShape(shape, false);
    }

    public static boolean canConvertToEnum(StringShape shape, boolean synthesizeEnumNames) {
        if (shape.isEnumShape()) {
            return true;
        }
        if (!shape.hasTrait(EnumTrait.class)) {
            LOGGER.info(String.format("Unable to convert string shape `%s` to enum shape because it doesn't have an enum trait.", shape.getId()));
            return false;
        }
        EnumTrait trait = shape.expectTrait(EnumTrait.class);
        if (!trait.hasNames() && !synthesizeEnumNames) {
            LOGGER.info(String.format("Unable to convert string shape `%s` to enum shape because it doesn't define names. The `synthesizeNames` option may be able to synthesize the names for you.", shape.getId()));
            return false;
        }
        for (EnumDefinition definition : trait.getValues()) {
            if (EnumShape.canConvertEnumDefinitionToMember(definition, synthesizeEnumNames)) continue;
            LOGGER.info(String.format("Unable to convert string shape `%s` to enum shape because it has at least one value which cannot be safely synthesized into a name: %s", shape.getId(), definition.getValue()));
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Optional<MemberShape> memberFromEnumDefinition(EnumDefinition definition, ShapeId parentId, boolean synthesizeName) {
        String name;
        if (!definition.getName().isPresent()) {
            if (!EnumShape.canConvertEnumDefinitionToMember(definition, synthesizeName)) return Optional.empty();
            name = definition.getValue().replaceAll("[-.:/\\s]+", "_");
        } else {
            name = definition.getName().get();
        }
        try {
            MemberShape.Builder builder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(parentId.withMember(name))).target(UnitTypeTrait.UNIT).addTrait(EnumValueTrait.builder().stringValue(definition.getValue()).build());
            definition.getDocumentation().ifPresent(docs -> builder.addTrait(new DocumentationTrait((String)docs)));
            if (!definition.getTags().isEmpty()) {
                builder.addTrait(((TagsTrait.Builder)TagsTrait.builder().values(definition.getTags())).build());
            }
            if (definition.isDeprecated()) {
                builder.addTrait(DeprecatedTrait.builder().build());
            }
            if (!definition.hasTag("internal")) return Optional.of(builder.build());
            builder.addTrait(new InternalTrait());
            return Optional.of(builder.build());
        }
        catch (ShapeIdSyntaxException e) {
            return Optional.empty();
        }
    }

    static boolean canConvertEnumDefinitionToMember(EnumDefinition definition, boolean withSynthesizedNames) {
        return definition.getName().isPresent() || withSynthesizedNames && CONVERTABLE_VALUE.matcher(definition.getValue()).find();
    }

    static EnumDefinition enumDefinitionFromMember(MemberShape member) {
        EnumDefinition.Builder builder = EnumDefinition.builder().name(member.getMemberName());
        String traitValue = (String)member.getTrait(EnumValueTrait.class).flatMap(EnumValueTrait::getStringValue).orElseThrow(() -> new IllegalStateException("Enum definitions can only be made for string enums."));
        builder.value(traitValue);
        member.getTrait(DocumentationTrait.class).ifPresent(docTrait -> builder.documentation(docTrait.getValue()));
        member.getTrait(DeprecatedTrait.class).ifPresent(deprecatedTrait -> builder.deprecated(true));
        List<String> tags = member.getTrait(TagsTrait.class).map(StringListTrait::getValues).orElse(Collections.emptyList());
        builder.tags(tags);
        if (member.hasTrait(InternalTrait.ID) && !tags.contains("internal")) {
            builder.addTag("internal");
        }
        return builder.build();
    }

    @Override
    public ShapeType getType() {
        return ShapeType.ENUM;
    }

    public static final class Builder
    extends StringShape.Builder {
        private final BuilderRef<Map<String, MemberShape>> members = BuilderRef.forOrderedMap();

        @Override
        public EnumShape build() {
            Map<String, MemberShape> aggregatedMembers = NamedMemberUtils.computeMixinMembers(this.getMixins(), this.members, this.getId(), this.getSourceLocation());
            this.addSyntheticEnumTrait(aggregatedMembers.values());
            return new EnumShape(this, aggregatedMembers);
        }

        private void addSyntheticEnumTrait(Collection<MemberShape> memberShapes) {
            SyntheticEnumTrait.Builder builder = SyntheticEnumTrait.builder();
            builder.sourceLocation(this.getSourceLocation());
            for (MemberShape member : memberShapes) {
                try {
                    builder.addEnum(EnumShape.enumDefinitionFromMember(member));
                }
                catch (IllegalStateException e) {
                    return;
                }
            }
            this.addTrait(builder.build());
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.ENUM;
        }

        @Override
        public Builder id(ShapeId shapeId) {
            super.id(shapeId);
            for (MemberShape member : ((Map)this.members.peek()).values()) {
                this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
            }
            return this;
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        public Builder setMembersFromEnumTrait(EnumTrait trait, boolean synthesizeNames) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before adding a named enum trait to a string.");
            }
            this.clearMembers();
            for (EnumDefinition definition : trait.getValues()) {
                Optional<MemberShape> member = EnumShape.memberFromEnumDefinition(definition, this.getId(), synthesizeNames);
                if (member.isPresent()) {
                    this.addMember(member.get());
                    continue;
                }
                throw new IllegalStateException(String.format("Unable to convert enum trait entry with name: `%s` and value `%s` to an enum member.", definition.getName().orElse(""), definition.getValue()));
            }
            return this;
        }

        public Builder setMembersFromEnumTrait(EnumTrait trait) {
            return this.setMembersFromEnumTrait(trait, false);
        }

        public Builder members(Collection<MemberShape> members) {
            this.clearMembers();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return this;
        }

        @Override
        public Builder clearMembers() {
            this.members.clear();
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            if (!member.getTarget().equals(UnitTypeTrait.UNIT)) {
                throw new SourceException(String.format("Enum members may only target `smithy.api#Unit`, but found `%s`", member.getTarget()), this.getSourceLocation());
            }
            if (!member.hasTrait(EnumValueTrait.ID)) {
                member = ((MemberShape.Builder)member.toBuilder().addTrait(EnumValueTrait.builder().stringValue(member.getMemberName()).build())).build();
            }
            ((Map)this.members.get()).put(member.getMemberName(), member);
            return this;
        }

        public Builder addMember(String memberName, String enumValue) {
            return this.addMember(memberName, enumValue, null);
        }

        public Builder addMember(String memberName, String enumValue, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().target(UnitTypeTrait.UNIT).id(this.getId().withMember(memberName))).addTrait(EnumValueTrait.builder().stringValue(enumValue).build());
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.addMember(builder.build());
        }

        public Builder removeMember(String member) {
            if (this.members.hasValue()) {
                ((Map)this.members.get()).remove(member);
            }
            return this;
        }

        @Override
        public Builder addMixin(Shape shape) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before adding a mixin");
            }
            super.addMixin(shape);
            NamedMemberUtils.cleanMixins(shape, (Map)this.members.get());
            return this;
        }

        @Override
        public Builder removeMixin(ToShapeId shape) {
            super.removeMixin(shape);
            NamedMemberUtils.removeMixin(shape, (Map)this.members.get());
            return this;
        }

        @Override
        public Builder flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return this;
            }
            this.members(NamedMemberUtils.flattenMixins((Map)this.members.get(), this.getMixins(), this.getId(), this.getSourceLocation()));
            return (Builder)super.flattenMixins();
        }

        @Override
        public Builder source(SourceLocation source) {
            return (Builder)super.source(source);
        }
    }
}

