/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;

final class IdentitySelector
implements Selector {
    IdentitySelector() {
    }

    @Override
    public Set<Shape> select(Model model) {
        return this.select(model, Selector.StartingContext.DEFAULT);
    }

    @Override
    public Set<Shape> select(Model model, Selector.StartingContext context) {
        Collection<? extends Shape> startingShapes = context.getStartingShapes();
        if (startingShapes == null) {
            return model.toSet();
        }
        if (startingShapes instanceof Set) {
            return (Set)startingShapes;
        }
        return new HashSet<Shape>(startingShapes);
    }

    @Override
    public Stream<Shape> shapes(Model model, Selector.StartingContext context) {
        Collection<? extends Shape> startingShapes = context.getStartingShapes();
        if (startingShapes == null) {
            return model.shapes();
        }
        return startingShapes.stream();
    }

    @Override
    public Stream<Selector.ShapeMatch> matches(Model model, Selector.StartingContext context) {
        Collection<? extends Shape> startingShapes = context.getStartingShapes();
        Stream<Shape> shapeStream = startingShapes == null ? model.shapes() : startingShapes.stream();
        return shapeStream.map(shape -> new Selector.ShapeMatch((Shape)shape, Collections.emptyMap()));
    }

    public String toString() {
        return "*";
    }

    public boolean equals(Object other) {
        return other instanceof Selector && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

