/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Optional;
import software.amazon.smithy.model.neighbor.RelationshipDirection;

public enum RelationshipType {
    RESOURCE("resource", RelationshipDirection.DIRECTED),
    OPERATION("operation", RelationshipDirection.DIRECTED),
    COLLECTION_OPERATION("collectionOperation", RelationshipDirection.DIRECTED),
    INSTANCE_OPERATION("instanceOperation", RelationshipDirection.DIRECTED),
    BOUND("bound", RelationshipDirection.INVERTED),
    PUT("put", RelationshipDirection.DIRECTED),
    CREATE("create", RelationshipDirection.DIRECTED),
    READ("read", RelationshipDirection.DIRECTED),
    UPDATE("update", RelationshipDirection.DIRECTED),
    DELETE("delete", RelationshipDirection.DIRECTED),
    LIST("list", RelationshipDirection.DIRECTED),
    IDENTIFIER("identifier", RelationshipDirection.DIRECTED),
    PROPERTY("property", RelationshipDirection.DIRECTED),
    MEMBER_CONTAINER(null, RelationshipDirection.INVERTED),
    MEMBER_TARGET(null, RelationshipDirection.DIRECTED),
    INPUT("input", RelationshipDirection.DIRECTED),
    OUTPUT("output", RelationshipDirection.DIRECTED),
    ERROR("error", RelationshipDirection.DIRECTED),
    ENUM_MEMBER("member", RelationshipDirection.DIRECTED),
    INT_ENUM_MEMBER("member", RelationshipDirection.DIRECTED),
    LIST_MEMBER("member", RelationshipDirection.DIRECTED),
    SET_MEMBER("member", RelationshipDirection.DIRECTED),
    MAP_KEY("member", RelationshipDirection.DIRECTED),
    MAP_VALUE("member", RelationshipDirection.DIRECTED),
    STRUCTURE_MEMBER("member", RelationshipDirection.DIRECTED),
    UNION_MEMBER("member", RelationshipDirection.DIRECTED),
    TRAIT("trait", RelationshipDirection.DIRECTED),
    MIXIN("mixin", RelationshipDirection.DIRECTED),
    ID_REF(null, RelationshipDirection.DIRECTED);

    private String selectorLabel;
    private RelationshipDirection direction;

    private RelationshipType(String selectorLabel, RelationshipDirection direction) {
        this.selectorLabel = selectorLabel;
        this.direction = direction;
    }

    public Optional<String> getSelectorLabel() {
        return Optional.ofNullable(this.selectorLabel);
    }

    public RelationshipDirection getDirection() {
        return this.direction;
    }

    public boolean isMemberBinding() {
        switch (this) {
            case STRUCTURE_MEMBER: 
            case UNION_MEMBER: 
            case LIST_MEMBER: 
            case SET_MEMBER: 
            case MAP_KEY: 
            case MAP_VALUE: 
            case INT_ENUM_MEMBER: 
            case ENUM_MEMBER: {
                return true;
            }
        }
        return false;
    }

    public boolean isOperationBinding() {
        return this.isInstanceOperationBinding() || this.isCollectionOperationBinding();
    }

    public boolean isInstanceOperationBinding() {
        switch (this) {
            case OPERATION: 
            case READ: 
            case UPDATE: 
            case DELETE: 
            case PUT: {
                return true;
            }
        }
        return false;
    }

    public boolean isCollectionOperationBinding() {
        switch (this) {
            case COLLECTION_OPERATION: 
            case CREATE: 
            case LIST: {
                return true;
            }
        }
        return false;
    }
}

