/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;

final class NeighborVisitor
extends ShapeVisitor.Default<List<Relationship>>
implements NeighborProvider {
    private final Model model;

    NeighborVisitor(Model model) {
        this.model = model;
    }

    @Override
    public List<Relationship> getNeighbors(Shape shape) {
        return shape.accept(this);
    }

    @Override
    public List<Relationship> getDefault(Shape shape) {
        return shape.getMixins().isEmpty() ? Collections.emptyList() : this.initializeRelationships(shape, 0);
    }

    private List<Relationship> initializeRelationships(Shape shape, int knownMemberCount) {
        if (shape.isMemberShape()) {
            return new ArrayList<Relationship>(knownMemberCount);
        }
        ArrayList<Relationship> result = new ArrayList<Relationship>(knownMemberCount += shape.getMixins().size());
        for (ShapeId mixin : shape.getMixins()) {
            this.push(result, shape, RelationshipType.MIXIN, mixin);
        }
        return result;
    }

    @Override
    public List<Relationship> serviceShape(ServiceShape shape) {
        int neededSize = shape.getOperations().size() + shape.getResources().size() + shape.getErrors().size();
        List<Relationship> result = this.initializeRelationships(shape, neededSize);
        for (ShapeId operation : shape.getOperations()) {
            this.push(result, (Shape)shape, RelationshipType.OPERATION, operation);
        }
        for (ShapeId resource : shape.getResources()) {
            this.push(result, (Shape)shape, RelationshipType.RESOURCE, resource);
        }
        for (ShapeId errorId : shape.getErrors()) {
            this.push(result, (Shape)shape, RelationshipType.ERROR, errorId);
        }
        return result;
    }

    private void push(List<Relationship> result, Shape container, RelationshipType type, ShapeId bindingTarget) {
        result.add(this.relationship(container, type, bindingTarget));
    }

    private void push(List<Relationship> result, Shape container, RelationshipType type, MemberShape bindingTarget) {
        result.add(this.relationship(container, type, bindingTarget));
    }

    @Override
    public List<Relationship> resourceShape(ResourceShape shape) {
        int neededSize = shape.getAllOperations().size() + shape.getResources().size() + shape.getIdentifiers().size() + shape.getProperties().size();
        List<Relationship> result = this.initializeRelationships(shape, neededSize);
        shape.getIdentifiers().forEach((k, v) -> this.push(result, (Shape)shape, RelationshipType.IDENTIFIER, (ShapeId)v));
        shape.getProperties().forEach((k, v) -> this.push(result, (Shape)shape, RelationshipType.PROPERTY, (ShapeId)v));
        shape.getResources().forEach(id -> this.push(result, (Shape)shape, RelationshipType.RESOURCE, (ShapeId)id));
        shape.getList().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.LIST, (ShapeId)id));
        shape.getCreate().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.CREATE, (ShapeId)id));
        shape.getPut().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.PUT, (ShapeId)id));
        shape.getRead().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.READ, (ShapeId)id));
        shape.getUpdate().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.UPDATE, (ShapeId)id));
        shape.getDelete().ifPresent(id -> this.push(result, (Shape)shape, RelationshipType.DELETE, (ShapeId)id));
        shape.getOperations().forEach(id -> result.add(this.relationship((Shape)shape, RelationshipType.OPERATION, (ShapeId)id)));
        shape.getCollectionOperations().forEach(id -> this.push(result, (Shape)shape, RelationshipType.COLLECTION_OPERATION, (ShapeId)id));
        return result;
    }

    @Override
    public List<Relationship> operationShape(OperationShape shape) {
        ShapeId input = shape.getInput().orElse(null);
        ShapeId output = shape.getOutput().orElse(null);
        int assumedRelationshipCount = shape.getErrors().size() + (input == null ? 0 : 1) + (output == null ? 0 : 1);
        List<Relationship> result = this.initializeRelationships(shape, assumedRelationshipCount);
        if (input != null) {
            this.push(result, (Shape)shape, RelationshipType.INPUT, input);
        }
        if (output != null) {
            this.push(result, (Shape)shape, RelationshipType.OUTPUT, output);
        }
        for (ShapeId errorId : shape.getErrors()) {
            this.push(result, (Shape)shape, RelationshipType.ERROR, errorId);
        }
        return result;
    }

    @Override
    public List<Relationship> memberShape(MemberShape shape) {
        Shape container = this.model.getShape(shape.getContainer()).orElse(null);
        boolean isEnumShape = container instanceof EnumShape || container instanceof IntEnumShape;
        List<Relationship> result = this.initializeRelationships(shape, 1 + (isEnumShape ? 0 : 1));
        this.push(result, (Shape)shape, RelationshipType.MEMBER_CONTAINER, shape.getContainer());
        if (!isEnumShape) {
            this.push(result, (Shape)shape, RelationshipType.MEMBER_TARGET, shape.getTarget());
        }
        return result;
    }

    @Override
    public List<Relationship> enumShape(EnumShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, shape.getAllMembers().size());
        for (MemberShape member : shape.getAllMembers().values()) {
            this.push(result, (Shape)shape, RelationshipType.ENUM_MEMBER, member);
        }
        return result;
    }

    @Override
    public List<Relationship> intEnumShape(IntEnumShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, shape.getAllMembers().size());
        for (MemberShape member : shape.getAllMembers().values()) {
            this.push(result, (Shape)shape, RelationshipType.INT_ENUM_MEMBER, member);
        }
        return result;
    }

    @Override
    public List<Relationship> listShape(ListShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, 1);
        this.push(result, (Shape)shape, RelationshipType.LIST_MEMBER, shape.getMember());
        return result;
    }

    @Override
    public List<Relationship> setShape(SetShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, 1);
        this.push(result, (Shape)shape, RelationshipType.SET_MEMBER, shape.getMember());
        return result;
    }

    @Override
    public List<Relationship> mapShape(MapShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, 2);
        this.push(result, (Shape)shape, RelationshipType.MAP_KEY, shape.getKey());
        this.push(result, (Shape)shape, RelationshipType.MAP_VALUE, shape.getValue());
        return result;
    }

    @Override
    public List<Relationship> structureShape(StructureShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, shape.getAllMembers().size());
        for (MemberShape member : shape.getAllMembers().values()) {
            this.push(result, (Shape)shape, RelationshipType.STRUCTURE_MEMBER, member);
        }
        return result;
    }

    @Override
    public List<Relationship> unionShape(UnionShape shape) {
        List<Relationship> result = this.initializeRelationships(shape, shape.getAllMembers().size());
        for (MemberShape member : shape.getAllMembers().values()) {
            this.push(result, (Shape)shape, RelationshipType.UNION_MEMBER, member);
        }
        return result;
    }

    private Relationship relationship(Shape shape, RelationshipType type, MemberShape memberShape) {
        return Relationship.create(shape, type, memberShape);
    }

    private Relationship relationship(Shape shape, RelationshipType type, ShapeId neighborShapeId) {
        return this.model.getShape(neighborShapeId).map(target -> Relationship.create(shape, type, target)).orElseGet(() -> Relationship.createInvalid(shape, type, neighborShapeId));
    }
}

