/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.XmlFlattenedTrait;
import software.amazon.smithy.model.traits.XmlNameTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class XmlFlattenedTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapesWithTrait(XmlFlattenedTrait.class)) {
            Shape target;
            if (member.hasTrait(XmlNameTrait.ID) || !((target = model.expectShape(member.getTarget())) instanceof ListShape)) continue;
            ListShape targetList = (ListShape)target;
            this.validateMemberTargetingList(member, targetList, events);
        }
        return events;
    }

    private void validateMemberTargetingList(MemberShape member, ListShape targetList, List<ValidationEvent> events) {
        if (targetList.getMember().hasTrait(XmlNameTrait.ID)) {
            XmlNameTrait xmlName = targetList.getMember().expectTrait(XmlNameTrait.class);
            if (!member.getMemberName().equals(xmlName.getValue())) {
                events.add(this.warning(member, String.format("Member is `@xmlFlattened`, so `@xmlName` of target's member (`%s`) has no effect. The flattened list elements will have the name of this member - `%s`. If this is unintended, you can add `@xmlName(\"%s\")` to this member.", targetList.getMember().getId(), member.getMemberName(), xmlName.getValue())));
            }
        }
    }
}

