/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ParserUtils {
    private ParserUtils() {
    }

    public static String parseNumber(SimpleParser parser) {
        int startPosition = parser.position();
        char current = parser.peek();
        if (current == '-') {
            parser.skip();
            if (!ParserUtils.isDigit(parser.peek())) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'-' must be followed by a digit"));
            }
        }
        parser.consumeWhile(ParserUtils::isDigit);
        char peek = parser.peek();
        if (peek == '.') {
            parser.skip();
            if (parser.consumeWhile(ParserUtils::isDigit) == 0) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'.' must be followed by a digit"));
            }
        }
        if ((peek = parser.peek()) == 'e' || peek == 'E') {
            parser.skip();
            peek = parser.peek();
            if (peek == '+' || peek == '-') {
                parser.skip();
            }
            if (parser.consumeWhile(ParserUtils::isDigit) == 0) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'e', '+', and '-' must be followed by a digit"));
            }
        }
        return parser.sliceFrom(startPosition);
    }

    private static String createInvalidString(SimpleParser parser, int startPosition, String message) {
        String lexeme = parser.sliceFrom(startPosition);
        return String.format("Invalid number '%s': %s", lexeme, message);
    }

    public static String parseIdentifier(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeIdentifier(parser);
        return parser.sliceFrom(start);
    }

    public static String parseRootShapeId(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeShapeId(parser, false);
        return parser.sliceFrom(start);
    }

    public static String parseShapeId(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeShapeId(parser, true);
        return parser.sliceFrom(start);
    }

    private static void consumeShapeId(SimpleParser parser, boolean parseMember) {
        ParserUtils.consumeNamespace(parser);
        if (parser.peek() == '#') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
        if (parseMember && parser.peek() == '$') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
    }

    public static void consumeNamespace(SimpleParser parser) {
        ParserUtils.consumeIdentifier(parser);
        while (parser.peek() == '.') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
    }

    public static void consumeIdentifier(SimpleParser parser) {
        char c = parser.peek();
        if (c == '_') {
            parser.consumeWhile(next -> next == 95);
            if (!ParserUtils.isValidIdentifierCharacter(parser.peek())) {
                throw ParserUtils.invalidIdentifier(parser);
            }
        } else if (!ParserUtils.isAlphabetic(c)) {
            throw ParserUtils.invalidIdentifier(parser);
        }
        parser.skip();
        parser.consumeWhile(ParserUtils::isValidIdentifierCharacter);
    }

    private static RuntimeException invalidIdentifier(SimpleParser parser) {
        throw parser.syntax("Expected a valid identifier character, but found '" + parser.peekSingleCharForMessage() + '\'');
    }

    public static boolean isValidIdentifierCharacter(char c) {
        return ParserUtils.isValidIdentifierCharacter((int)c);
    }

    public static boolean isValidIdentifierCharacter(int c) {
        return ParserUtils.isIdentifierStart(c) || ParserUtils.isDigit(c);
    }

    public static boolean isIdentifierStart(char c) {
        return ParserUtils.isIdentifierStart((int)c);
    }

    public static boolean isIdentifierStart(int c) {
        return c == 95 || ParserUtils.isAlphabetic(c);
    }

    public static boolean isDigit(char c) {
        return ParserUtils.isDigit((int)c);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isAlphabetic(char c) {
        return ParserUtils.isAlphabetic((int)c);
    }

    public static boolean isAlphabetic(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }
}

