/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.ListUtils;

public final class BottomUpIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, List<EntityShape>>> parentBindings = new HashMap<ShapeId, Map<ShapeId, List<EntityShape>>>();

    public BottomUpIndex(Model model) {
        NeighborProvider provider = NeighborProviderIndex.of(model).getProvider();
        for (ServiceShape service : model.getServiceShapes()) {
            HashMap<ShapeId, List<EntityShape>> paths = new HashMap<ShapeId, List<EntityShape>>();
            this.parentBindings.put(service.getId(), paths);
            ArrayDeque<EntityShape> path = new ArrayDeque<EntityShape>();
            path.push(service);
            this.collectPaths(paths, path, service, provider);
        }
    }

    private void collectPaths(Map<ShapeId, List<EntityShape>> paths, Deque<EntityShape> path, Shape current, NeighborProvider neighborProvider) {
        for (Relationship relationship : neighborProvider.getNeighbors(current)) {
            Shape neighbor = relationship.expectNeighborShape();
            if (!neighbor.isOperationShape() && !neighbor.isResourceShape()) continue;
            paths.put(neighbor.getId(), ListUtils.copyOf(path));
            if (!(neighbor instanceof EntityShape)) continue;
            path.push((EntityShape)neighbor);
            this.collectPaths(paths, path, neighbor, neighborProvider);
            path.pop();
        }
    }

    public static BottomUpIndex of(Model model) {
        return model.getKnowledge(BottomUpIndex.class, BottomUpIndex::new);
    }

    public List<EntityShape> getAllParents(ToShapeId service, ToShapeId operationOrResource) {
        Map serviceBindings = this.parentBindings.getOrDefault(service.toShapeId(), Collections.emptyMap());
        List entities = (List)serviceBindings.get(operationOrResource.toShapeId());
        return entities == null ? Collections.emptyList() : Collections.unmodifiableList(entities);
    }

    public Optional<EntityShape> getEntityBinding(ToShapeId service, ToShapeId operationOrResource) {
        List<EntityShape> entities = this.getAllParents(service, operationOrResource);
        return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
    }

    public Optional<ResourceShape> getResourceBinding(ToShapeId service, ToShapeId operationOrResource) {
        return this.getEntityBinding(service, operationOrResource).filter(ResourceShape.class::isInstance).map(ResourceShape.class::cast);
    }
}

