/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.AttributeComparator;
import software.amazon.smithy.model.selector.AttributeSelector;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.InSelector;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.IsSelector;
import software.amazon.smithy.model.selector.NeighborSelector;
import software.amazon.smithy.model.selector.NotSelector;
import software.amazon.smithy.model.selector.RecursiveNeighborSelector;
import software.amazon.smithy.model.selector.RecursiveSelector;
import software.amazon.smithy.model.selector.RootSelector;
import software.amazon.smithy.model.selector.ScopedAttributeSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.selector.ShapeTypeCategorySelector;
import software.amazon.smithy.model.selector.ShapeTypeSelector;
import software.amazon.smithy.model.selector.TestSelector;
import software.amazon.smithy.model.selector.TopDownSelector;
import software.amazon.smithy.model.selector.VariableGetSelector;
import software.amazon.smithy.model.selector.VariableStoreSelector;
import software.amazon.smithy.model.selector.WrappedSelector;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SimpleParser;

final class SelectorParser
extends SimpleParser {
    private static final Logger LOGGER = Logger.getLogger(SelectorParser.class.getName());
    private static final Set<Character> BREAK_TOKENS = SetUtils.of((Object[])new Character[]{Character.valueOf(','), Character.valueOf(']'), Character.valueOf(')')});
    private static final Set<String> REL_TYPES = new HashSet<String>();
    private final List<InternalSelector> roots = new ArrayList<InternalSelector>();

    private SelectorParser(String selector) {
        super((CharSequence)selector);
    }

    static Selector parse(String selector) {
        SelectorParser parser = new SelectorParser(selector);
        List<InternalSelector> result = parser.parse();
        return new WrappedSelector(selector, result, parser.roots);
    }

    List<InternalSelector> parse() {
        return this.recursiveParse();
    }

    private List<InternalSelector> recursiveParse() {
        IgnoreIdentitySelectorArray selectors = new IgnoreIdentitySelectorArray();
        selectors.add(this.createSelector());
        this.ws();
        while (!this.eof() && !BREAK_TOKENS.contains(Character.valueOf(this.peek()))) {
            selectors.add(this.createSelector());
            this.ws();
        }
        return selectors;
    }

    private InternalSelector createSelector() {
        this.ws();
        switch (this.peek()) {
            case ':': {
                this.skip();
                return this.parseSelectorFunction();
            }
            case '[': {
                this.skip();
                if (this.peek() == '@') {
                    this.skip();
                    return this.parseScopedAttribute();
                }
                return this.parseAttribute();
            }
            case '>': {
                this.skip();
                return NeighborSelector.FORWARD;
            }
            case '<': {
                this.skip();
                if (this.peek() == '-') {
                    this.skip();
                    this.expect('[');
                    return this.parseSelectorDirectedReverseNeighbor();
                }
                return NeighborSelector.REVERSE;
            }
            case '~': {
                this.skip();
                this.expect('>');
                return new RecursiveNeighborSelector();
            }
            case '-': {
                this.skip();
                this.expect('[');
                return this.parseSelectorForwardDirectedNeighbor();
            }
            case '*': {
                this.skip();
                return InternalSelector.IDENTITY;
            }
            case '$': {
                this.skip();
                return this.parseVariable();
            }
        }
        if (ParserUtils.isIdentifierStart(this.peek())) {
            String identifier;
            switch (identifier = ParserUtils.parseIdentifier(this)) {
                case "number": {
                    return new ShapeTypeCategorySelector(NumberShape.class);
                }
                case "simpleType": {
                    return new ShapeTypeCategorySelector(SimpleShape.class);
                }
                case "collection": {
                    return new ShapeTypeCategorySelector(CollectionShape.class);
                }
            }
            ShapeType shape = ShapeType.fromString(identifier).orElseThrow(() -> this.syntax("Unknown shape type: " + identifier));
            return new ShapeTypeSelector(shape);
        }
        if (this.peek() == '\u0000') {
            throw this.syntax("Unexpected selector EOF");
        }
        throw this.syntax("Unexpected selector character: " + this.peek());
    }

    public SelectorSyntaxException syntax(String message) {
        return new SelectorSyntaxException(message, this.input().toString(), this.position(), this.line(), this.column());
    }

    private InternalSelector parseVariable() {
        this.ws();
        if (this.peek() == '{') {
            this.skip();
            this.ws();
            String variableName = ParserUtils.parseIdentifier(this);
            this.ws();
            this.expect('}');
            return new VariableGetSelector(variableName);
        }
        String name = ParserUtils.parseIdentifier(this);
        this.ws();
        this.expect('(');
        this.ws();
        InternalSelector selector = AndSelector.of(this.recursiveParse());
        this.ws();
        this.expect(')');
        return new VariableStoreSelector(name, selector);
    }

    private InternalSelector parseSelectorForwardDirectedNeighbor() {
        List<String> relationships = this.parseSelectorDirectedRelationships();
        this.expect('-');
        this.expect('>');
        return NeighborSelector.forward(relationships);
    }

    private InternalSelector parseSelectorDirectedReverseNeighbor() {
        List<String> relationships = this.parseSelectorDirectedRelationships();
        this.expect('-');
        return NeighborSelector.reverse(relationships);
    }

    private List<String> parseSelectorDirectedRelationships() {
        char peek;
        ArrayList<String> relationships = new ArrayList<String>();
        do {
            this.ws();
            String next = ParserUtils.parseIdentifier(this);
            relationships.add(next);
            if (!REL_TYPES.contains(next)) {
                LOGGER.warning(String.format("Unknown relationship type '%s' found near %s. Expected one of: %s", next, this.position() - next.length(), REL_TYPES));
            }
            this.ws();
        } while ((peek = this.expect(new char[]{']', ','})) != ']');
        return relationships;
    }

    private InternalSelector parseSelectorFunction() {
        int functionPosition = this.position();
        String name = ParserUtils.parseIdentifier(this);
        List<InternalSelector> selectors = this.parseSelectorFunctionArgs();
        switch (name) {
            case "not": {
                if (selectors.size() != 1) {
                    throw new SelectorSyntaxException("The :not function requires a single selector argument", this.input().toString(), functionPosition, this.line(), this.column());
                }
                return new NotSelector(selectors.get(0));
            }
            case "test": {
                return new TestSelector(selectors);
            }
            case "is": {
                return IsSelector.of(selectors);
            }
            case "in": {
                if (selectors.size() != 1) {
                    throw new SelectorSyntaxException("The :in function requires a single selector argument", this.input().toString(), functionPosition, this.line(), this.column());
                }
                return new InSelector(selectors.get(0));
            }
            case "root": {
                if (selectors.size() != 1) {
                    throw new SelectorSyntaxException("The :root function requires a single selector argument", this.input().toString(), functionPosition, this.line(), this.column());
                }
                RootSelector root = new RootSelector(selectors.get(0), this.roots.size());
                this.roots.add(selectors.get(0));
                return root;
            }
            case "topdown": {
                if (selectors.size() > 2) {
                    throw new SelectorSyntaxException("The :topdown function accepts 1 or 2 selectors, but found " + selectors.size(), this.input().toString(), functionPosition, this.line(), this.column());
                }
                return new TopDownSelector(selectors);
            }
            case "recursive": {
                if (selectors.size() != 1) {
                    throw new SelectorSyntaxException("The :recursive function requires a single selector argument", this.input().toString(), functionPosition, this.line(), this.column());
                }
                return new RecursiveSelector(selectors.get(0));
            }
            case "each": {
                LOGGER.warning("The `:each` selector function has been renamed to `:is`: " + this.input());
                return IsSelector.of(selectors);
            }
        }
        LOGGER.warning(String.format("Unknown function name `%s` found in selector: %s", name, this.input()));
        return (context, shape, next) -> InternalSelector.Response.CONTINUE;
    }

    private List<InternalSelector> parseSelectorFunctionArgs() {
        char next;
        this.ws();
        ArrayList<InternalSelector> selectors = new ArrayList<InternalSelector>();
        this.expect('(');
        do {
            selectors.add(AndSelector.of(this.recursiveParse()));
            this.ws();
        } while ((next = this.expect(new char[]{')', ','})) != ')');
        return selectors;
    }

    private InternalSelector parseAttribute() {
        this.ws();
        List<String> path = this.parseAttributePath();
        this.ws();
        char next = this.expect(new char[]{']', '=', '!', '^', '$', '*', '?', '>', '<'});
        if (next == ']') {
            return AttributeSelector.existence(path);
        }
        AttributeComparator comparator = this.parseComparator(next);
        List<String> values = this.parseAttributeValues();
        boolean insensitive = this.parseCaseInsensitiveToken();
        this.expect(']');
        return new AttributeSelector(path, values, comparator, insensitive);
    }

    private boolean parseCaseInsensitiveToken() {
        boolean insensitive;
        this.ws();
        boolean bl = insensitive = this.peek() == 'i';
        if (insensitive) {
            this.skip();
            this.ws();
        }
        return insensitive;
    }

    private AttributeComparator parseComparator(char next) {
        AttributeComparator comparator;
        switch (next) {
            case '=': {
                comparator = AttributeComparator.EQUALS;
                break;
            }
            case '!': {
                this.expect('=');
                comparator = AttributeComparator.NOT_EQUALS;
                break;
            }
            case '^': {
                this.expect('=');
                comparator = AttributeComparator.STARTS_WITH;
                break;
            }
            case '$': {
                this.expect('=');
                comparator = AttributeComparator.ENDS_WITH;
                break;
            }
            case '*': {
                this.expect('=');
                comparator = AttributeComparator.CONTAINS;
                break;
            }
            case '?': {
                this.expect('=');
                comparator = AttributeComparator.EXISTS;
                break;
            }
            case '>': {
                if (this.peek() == '=') {
                    this.skip();
                    comparator = AttributeComparator.GTE;
                    break;
                }
                comparator = AttributeComparator.GT;
                break;
            }
            case '<': {
                if (this.peek() == '=') {
                    this.skip();
                    comparator = AttributeComparator.LTE;
                    break;
                }
                comparator = AttributeComparator.LT;
                break;
            }
            case '{': {
                char nextSet = this.expect(new char[]{'<', '=', '!'});
                if (nextSet == '<') {
                    if (this.peek() == '<') {
                        this.expect('<');
                        comparator = AttributeComparator.PROPER_SUBSET;
                    } else {
                        comparator = AttributeComparator.SUBSET;
                    }
                } else if (nextSet == '=') {
                    comparator = AttributeComparator.PROJECTION_EQUALS;
                } else {
                    this.expect('=');
                    comparator = AttributeComparator.PROJECTION_NOT_EQUALS;
                }
                this.expect('}');
                break;
            }
            default: {
                throw this.syntax("Unknown attribute comparator token '" + next + "'");
            }
        }
        this.ws();
        return comparator;
    }

    private InternalSelector parseScopedAttribute() {
        this.ws();
        List<String> path = this.parseAttributePath();
        this.ws();
        this.expect(':');
        this.ws();
        return new ScopedAttributeSelector(path, this.parseScopedAssertions());
    }

    private List<ScopedAttributeSelector.Assertion> parseScopedAssertions() {
        ArrayList<ScopedAttributeSelector.Assertion> assertions = new ArrayList<ScopedAttributeSelector.Assertion>();
        assertions.add(this.parseScopedAssertion());
        this.ws();
        while (this.peek() == '&') {
            this.expect('&');
            this.expect('&');
            this.ws();
            assertions.add(this.parseScopedAssertion());
        }
        this.expect(']');
        return assertions;
    }

    private ScopedAttributeSelector.Assertion parseScopedAssertion() {
        ScopedAttributeSelector.ScopedFactory lhs = this.parseScopedValue();
        char next = this.peek();
        this.skip();
        AttributeComparator comparator = this.parseComparator(next);
        ArrayList<ScopedAttributeSelector.ScopedFactory> rhs = new ArrayList<ScopedAttributeSelector.ScopedFactory>();
        rhs.add(this.parseScopedValue());
        while (this.peek() == ',') {
            this.skip();
            rhs.add(this.parseScopedValue());
        }
        boolean insensitive = this.parseCaseInsensitiveToken();
        return new ScopedAttributeSelector.Assertion(lhs, comparator, rhs, insensitive);
    }

    private ScopedAttributeSelector.ScopedFactory parseScopedValue() {
        this.ws();
        if (this.peek() == '@') {
            List<String> path = SelectorParser.parseScopedValuePath(this);
            this.ws();
            return value -> value.getPath(path);
        }
        String parsedValue = SelectorParser.parseAttributeValue(this);
        this.ws();
        return value -> AttributeValue.literal(parsedValue);
    }

    private List<String> parseAttributePath() {
        this.ws();
        if (this.peek() == ':') {
            return Collections.emptyList();
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(ParserUtils.parseIdentifier(this));
        path.addAll(SelectorParser.parseSelectorPath(this));
        return path;
    }

    private List<String> parseAttributeValues() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(SelectorParser.parseAttributeValue(this));
        this.ws();
        while (this.peek() == ',') {
            this.skip();
            result.add(SelectorParser.parseAttributeValue(this));
            this.ws();
        }
        return result;
    }

    static List<String> parseScopedValuePath(SimpleParser parser) {
        parser.expect('@');
        parser.expect('{');
        ArrayList<String> path = new ArrayList<String>();
        path.add(SelectorParser.parseSelectorPathSegment(parser));
        path.addAll(SelectorParser.parseSelectorPath(parser));
        parser.expect('}');
        return path;
    }

    private static String parseSelectorPathSegment(SimpleParser parser) {
        parser.ws();
        if (parser.peek() == '(') {
            parser.skip();
            String propertyName = ParserUtils.parseIdentifier(parser);
            parser.expect(')');
            return "(" + propertyName + ")";
        }
        return SelectorParser.parseAttributeValue(parser);
    }

    private static String parseAttributeValue(SimpleParser parser) {
        parser.ws();
        switch (parser.peek()) {
            case '\'': {
                return SelectorParser.consumeInside(parser, '\'');
            }
            case '\"': {
                return SelectorParser.consumeInside(parser, '\"');
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return ParserUtils.parseNumber(parser);
            }
        }
        return ParserUtils.parseRootShapeId(parser);
    }

    private static String consumeInside(SimpleParser parser, char c) {
        parser.skip();
        int start = parser.position();
        while (!parser.eof()) {
            if (parser.peek() == c) {
                String result = parser.sliceFrom(start);
                parser.skip();
                parser.ws();
                return result;
            }
            parser.skip();
        }
        throw parser.syntax("Expected " + c + " to close " + parser.sliceFrom(start));
    }

    private static List<String> parseSelectorPath(SimpleParser parser) {
        parser.ws();
        if (parser.peek() != '|') {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        do {
            parser.skip();
            result.add(SelectorParser.parseSelectorPathSegment(parser));
        } while (parser.peek() == '|');
        return result;
    }

    static {
        for (RelationshipType rel : RelationshipType.values()) {
            rel.getSelectorLabel().ifPresent(REL_TYPES::add);
        }
    }

    private static final class IgnoreIdentitySelectorArray
    extends ArrayList<InternalSelector> {
        private IgnoreIdentitySelectorArray() {
        }

        @Override
        public boolean add(InternalSelector o) {
            return o != InternalSelector.IDENTITY && super.add(o);
        }
    }
}

