/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraitDefinition
extends AbstractTrait
implements ToSmithyBuilder<TraitDefinition> {
    public static final ShapeId ID = ShapeId.from("smithy.api#trait");
    public static final String SELECTOR_KEY = "selector";
    public static final String STRUCTURALLY_EXCLUSIVE_KEY = "structurallyExclusive";
    public static final String CONFLICTS_KEY = "conflicts";
    private final Selector selector;
    private final List<ShapeId> conflicts;
    private final StructurallyExclusive structurallyExclusive;

    public TraitDefinition(Builder builder) {
        super(ID, builder.sourceLocation);
        this.selector = builder.selector;
        this.conflicts = ListUtils.copyOf((Collection)builder.conflicts);
        this.structurallyExclusive = builder.structurallyExclusive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = TraitDefinition.builder().selector(this.selector).structurallyExclusive(this.structurallyExclusive);
        this.conflicts.forEach(builder::addConflict);
        return builder;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public List<ShapeId> getConflicts() {
        return this.conflicts;
    }

    public Optional<StructurallyExclusive> getStructurallyExclusive() {
        return Optional.ofNullable(this.structurallyExclusive);
    }

    public boolean isStructurallyExclusiveByMember() {
        return this.structurallyExclusive == StructurallyExclusive.MEMBER;
    }

    public boolean isStructurallyExclusiveByTarget() {
        return this.structurallyExclusive == StructurallyExclusive.TARGET;
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation());
        if (this.selector != Selector.IDENTITY) {
            builder.withMember(SELECTOR_KEY, this.selector.toString());
        }
        if (!this.conflicts.isEmpty()) {
            builder.withMember(CONFLICTS_KEY, this.conflicts.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect()));
        }
        builder.withOptionalMember(STRUCTURALLY_EXCLUSIVE_KEY, this.getStructurallyExclusive().map(StructurallyExclusive::toString).map(Node::from));
        return builder.build();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public TraitDefinition createTrait(ShapeId target, Node value) {
            ObjectNode members = value.isNullNode() ? Node.objectNode() : value.expectObjectNode();
            Builder builder = (Builder)TraitDefinition.builder().sourceLocation(value);
            members.getMember(TraitDefinition.SELECTOR_KEY).map(Selector::fromNode).ifPresent(builder::selector);
            members.getStringMember(TraitDefinition.STRUCTURALLY_EXCLUSIVE_KEY).map(node -> node.expectOneOf(StructurallyExclusive.MEMBER.toString(), StructurallyExclusive.TARGET.toString())).map(string -> string.toUpperCase(Locale.ENGLISH)).map(StructurallyExclusive::valueOf).ifPresent(builder::structurallyExclusive);
            members.getMember(TraitDefinition.CONFLICTS_KEY).ifPresent(values -> Node.loadArrayOfString(TraitDefinition.CONFLICTS_KEY, values).forEach(builder::addConflict));
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<TraitDefinition, Builder> {
        private Selector selector = Selector.IDENTITY;
        private final List<ShapeId> conflicts = new ArrayList<ShapeId>();
        private StructurallyExclusive structurallyExclusive;

        private Builder() {
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder addConflict(String trait) {
            Objects.requireNonNull(trait);
            return this.addConflict(ShapeId.from(trait));
        }

        public Builder addConflict(ShapeId id) {
            Objects.requireNonNull(id);
            this.conflicts.add(id);
            return this;
        }

        public Builder removeConflict(ToShapeId id) {
            this.conflicts.remove(id.toShapeId());
            return this;
        }

        public Builder structurallyExclusive(StructurallyExclusive structurallyExclusive) {
            this.structurallyExclusive = structurallyExclusive;
            return this;
        }

        public TraitDefinition build() {
            return new TraitDefinition(this);
        }
    }

    public static enum StructurallyExclusive {
        MEMBER,
        TARGET;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

