/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.MetadataContainer;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidationEvent;

abstract class AbstractMutableModelFile
implements ModelFile {
    protected final TraitContainer traitContainer;
    private final Map<ShapeId, AbstractShapeBuilder<?, ?>> shapes = new LinkedHashMap();
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
    private final MetadataContainer metadata = new MetadataContainer(this.events);
    private final TraitFactory traitFactory;

    AbstractMutableModelFile(TraitFactory traitFactory) {
        this.traitFactory = Objects.requireNonNull(traitFactory, "traitFactory must not be null");
        this.traitContainer = new TraitContainer.TraitHashMap(traitFactory, this.events);
    }

    void onShape(AbstractShapeBuilder<?, ?> builder) {
        if (this.shapes.containsKey(builder.getId())) {
            AbstractShapeBuilder<?, ?> previous = this.shapes.get(builder.getId());
            ValidationEvent event = LoaderUtils.onShapeConflict(builder.getId(), builder.getSourceLocation(), previous.getSourceLocation());
            throw new SourceException(event.getMessage(), event.getSourceLocation());
        }
        this.shapes.put(builder.getId(), builder);
    }

    final void putMetadata(String key, Node value) {
        this.metadata.putMetadata(key, value);
    }

    final void onTrait(ShapeId target, ShapeId trait, Node value) {
        this.traitContainer.onTrait(target, trait, value);
    }

    final void onTrait(ShapeId target, Trait trait) {
        this.traitContainer.onTrait(target, trait);
    }

    @Override
    public final List<ValidationEvent> events() {
        return this.events;
    }

    @Override
    public final Map<String, Node> metadata() {
        return this.metadata.getData();
    }

    @Override
    public final Set<ShapeId> shapeIds() {
        return this.shapes.keySet();
    }

    @Override
    public final Collection<Shape> createShapes(TraitContainer resolvedTraits) {
        ArrayList<Shape> resolved = new ArrayList<Shape>(this.shapes.size());
        for (AbstractShapeBuilder<?, ?> builder : this.shapes.values()) {
            if (!(builder instanceof MemberShape.Builder)) continue;
            ShapeId id = builder.getId();
            AbstractShapeBuilder<?, ?> container = this.shapes.get(id.withoutMember());
            if (container == null) {
                throw new RuntimeException("Container shape not found for member: " + id);
            }
            for (Trait trait : resolvedTraits.getTraitsForShape(id).values()) {
                builder.addTrait(trait);
            }
            container.addMember((MemberShape)builder.build());
        }
        for (AbstractShapeBuilder<?, ?> builder : this.shapes.values()) {
            if (builder instanceof MemberShape.Builder) continue;
            try {
                for (Trait trait : resolvedTraits.getTraitsForShape(builder.getId()).values()) {
                    builder.addTrait(trait);
                }
                resolved.add((Shape)builder.build());
            }
            catch (SourceException e) {
                this.events.add(ValidationEvent.fromSourceException(e).toBuilder().shapeId(builder.getId()).build());
            }
        }
        return resolved;
    }

    @Override
    public final ShapeType getShapeType(ShapeId id) {
        return this.shapes.containsKey(id) ? this.shapes.get(id).getShapeType() : null;
    }
}

