/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class ServiceBoundResourceOperationValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        OperationIndex operationIndex = OperationIndex.of(model);
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        for (ServiceShape service : model.getServiceShapes()) {
            HashMap<OperationShape, Set> potentiallyBetterBindings = new HashMap<OperationShape, Set>();
            for (ShapeId shapeId : service.getOperations()) {
                OperationShape operation = model.expectShape(shapeId, OperationShape.class);
                for (ResourceShape resource : topDownIndex.getContainedResources(service)) {
                    for (MemberShape member : operationIndex.getInputMembers(operation).values()) {
                        if (!this.isImplicitIdentifierBinding(member, resource)) continue;
                        potentiallyBetterBindings.computeIfAbsent(operation, k -> new HashSet()).add(resource.getId());
                    }
                    for (MemberShape member : operationIndex.getOutputMembers(operation).values()) {
                        if (!this.isImplicitIdentifierBinding(member, resource)) continue;
                        potentiallyBetterBindings.computeIfAbsent(operation, k -> new HashSet()).add(resource.getId());
                    }
                }
            }
            for (Map.Entry entry : potentiallyBetterBindings.entrySet()) {
                events.add(this.warning((Shape)entry.getKey(), service, String.format("The `%s` operation is bound to the `%s` service but has members that match identifiers of the following resource shapes: [%s]. It may be more accurately bound to one of them than directly to the service.", ((OperationShape)entry.getKey()).getId(), service.getId(), ValidationUtils.tickedList((Collection)entry.getValue())), service.getId().toString(), ((OperationShape)entry.getKey()).getId().getName()));
            }
        }
        return events;
    }

    private boolean isImplicitIdentifierBinding(MemberShape member, ResourceShape resource) {
        return resource.getIdentifiers().containsKey(member.getMemberName()) && member.hasTrait(RequiredTrait.ID) && member.getTarget().equals(resource.getIdentifiers().get(member.getMemberName()));
    }
}

