/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

public final class LengthTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(LengthTrait.class)) {
            events.addAll(this.validateLengthTrait(shape, shape.expectTrait(LengthTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateLengthTrait(Shape shape, LengthTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        trait.getMin().filter(min -> min < 0L).map(min -> this.error(shape, trait, "A length trait is applied with a negative `min` value.")).ifPresent(events::add);
        trait.getMax().filter(max -> max < 0L).map(max -> this.error(shape, trait, "A length trait is applied with a negative `max` value.")).ifPresent(events::add);
        trait.getMin().flatMap(min -> trait.getMax().map(max -> Pair.of((Object)min, (Object)max))).filter(pair -> (Long)pair.getLeft() > (Long)pair.getRight()).map(pair -> this.error(shape, trait, "A length trait is applied with a `min` value greater than its `max` value.")).map(events::add);
        return events;
    }
}

