/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.PrivateTrait;

public final class Prelude {
    public static final String NAMESPACE = "smithy.api";

    private Prelude() {
    }

    public static boolean isPreludeShape(ToShapeId id) {
        return id.toShapeId().getNamespace().equals(NAMESPACE);
    }

    public static boolean isPublicPreludeShape(ToShapeId id) {
        return Prelude.getPreludeModel().getShape(id.toShapeId()).filter(shape -> !shape.hasTrait(PrivateTrait.ID)).isPresent();
    }

    static Model getPreludeModel() {
        return PreludeHolder.PRELUDE;
    }

    private static final class PreludeHolder {
        private static final Model PRELUDE = PreludeHolder.loadPrelude();

        private PreludeHolder() {
        }

        private static Model loadPrelude() {
            return Model.assembler().disablePrelude().disableValidation().traitFactory(ModelAssembler.LazyTraitFactoryHolder.INSTANCE).addImport(Prelude.class.getResource("prelude.smithy")).addTrait(ShapeId.from("smithy.api#Boolean"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Byte"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Short"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Integer"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Long"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Float"), new BoxTrait()).addTrait(ShapeId.from("smithy.api#Double"), new BoxTrait()).assemble().unwrap();
        }
    }
}

