/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.MapUtils;

public enum SmithyIdlComponentOrder {
    ALPHA_NUMERIC,
    SOURCE_LOCATION,
    PREFERRED;


    Comparator<Shape> shapeComparator() {
        return this == PREFERRED ? new PreferredShapeComparator() : this.toShapeIdComparator();
    }

    <T extends FromSourceLocation & ToShapeId> Comparator<T> toShapeIdComparator() {
        switch (this) {
            case PREFERRED: 
            case ALPHA_NUMERIC: {
                return Comparator.comparing(rec$ -> ((ToShapeId)rec$).toShapeId());
            }
        }
        return new SourceComparator();
    }

    Comparator<Map.Entry<String, Node>> metadataComparator() {
        switch (this) {
            case PREFERRED: 
            case ALPHA_NUMERIC: {
                return Map.Entry.comparingByKey();
            }
        }
        return new MetadataComparator();
    }

    private static final class PreferredShapeComparator
    implements Comparator<Shape>,
    Serializable {
        private static final Map<ShapeType, Integer> PRIORITY = MapUtils.of((Object)((Object)ShapeType.SERVICE), (Object)0, (Object)((Object)ShapeType.RESOURCE), (Object)1, (Object)((Object)ShapeType.OPERATION), (Object)2, (Object)((Object)ShapeType.STRUCTURE), (Object)3, (Object)((Object)ShapeType.UNION), (Object)4, (Object)((Object)ShapeType.LIST), (Object)5, (Object)((Object)ShapeType.SET), (Object)6, (Object)((Object)ShapeType.MAP), (Object)7);

        private PreferredShapeComparator() {
        }

        @Override
        public int compare(Shape s1, Shape s2) {
            if (s1.hasTrait(TraitDefinition.ID) || s2.hasTrait(TraitDefinition.ID)) {
                if (!s1.hasTrait(TraitDefinition.ID)) {
                    return 1;
                }
                if (!s2.hasTrait(TraitDefinition.ID)) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            if (s1.getType().equals((Object)s2.getType())) {
                return s1.compareTo(s2);
            }
            if (PRIORITY.containsKey((Object)s1.getType()) || PRIORITY.containsKey((Object)s2.getType())) {
                if (!PRIORITY.containsKey((Object)s1.getType())) {
                    return 1;
                }
                if (!PRIORITY.containsKey((Object)s2.getType())) {
                    return -1;
                }
                return PRIORITY.get((Object)s1.getType()) - PRIORITY.get((Object)s2.getType());
            }
            return s1.compareTo(s2);
        }
    }

    private static final class SourceComparator<T extends FromSourceLocation & ToShapeId>
    implements Comparator<T>,
    Serializable {
        private SourceComparator() {
        }

        @Override
        public int compare(T a, T b) {
            SourceLocation right;
            SourceLocation left = a.getSourceLocation();
            int comparison = left.compareTo(right = b.getSourceLocation());
            return comparison != 0 ? comparison : ((ToShapeId)a).toShapeId().compareTo(((ToShapeId)b).toShapeId());
        }
    }

    private static final class MetadataComparator
    implements Comparator<Map.Entry<String, Node>>,
    Serializable {
        private MetadataComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Node> a, Map.Entry<String, Node> b) {
            SourceLocation right;
            SourceLocation left = a.getValue().getSourceLocation();
            int comparison = left.compareTo(right = b.getValue().getSourceLocation());
            return comparison != 0 ? comparison : a.getKey().compareTo(b.getKey());
        }
    }
}

