/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class ShapeTypeCategorySelector
implements InternalSelector {
    private final Class<? extends Shape> shapeCategory;

    ShapeTypeCategorySelector(Class<? extends Shape> shapeCategory) {
        this.shapeCategory = shapeCategory;
    }

    @Override
    public InternalSelector.Response push(Context ctx, Shape shape, InternalSelector.Receiver next) {
        if (this.shapeCategory.isInstance(shape)) {
            return next.apply(ctx, shape);
        }
        return InternalSelector.Response.CONTINUE;
    }

    @Override
    public Collection<? extends Shape> getStartingShapes(Model model) {
        return model.toSet(this.shapeCategory);
    }

    @Override
    public InternalSelector.ContainsShape containsShapeOptimization(Context context, Shape shape) {
        return this.getStartingShapes(context.getModel()).contains(shape) ? InternalSelector.ContainsShape.YES : InternalSelector.ContainsShape.NO;
    }
}

