/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanOperationStructures
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        return transformer.replaceShapes(model, this.getModifiedOperations(model, removed));
    }

    private Collection<Shape> getModifiedOperations(Model model, Collection<Shape> removed) {
        ArrayList<Shape> modifiedShapes = new ArrayList<Shape>();
        for (OperationShape operation : model.getOperationShapes()) {
            OperationShape.Builder builder = this.transformInput(removed, operation);
            builder = this.transformOutput(removed, operation, builder);
            if ((builder = this.transformErrors(removed, operation, builder)) == null) continue;
            modifiedShapes.add(builder.build());
        }
        return modifiedShapes;
    }

    private OperationShape.Builder transformInput(Collection<Shape> removed, OperationShape operation) {
        for (Shape remove : removed) {
            if (!remove.getId().equals(operation.getInputShape())) continue;
            OperationShape.Builder builder = operation.toBuilder();
            builder.input(null);
            return builder;
        }
        return null;
    }

    private OperationShape.Builder transformOutput(Collection<Shape> removed, OperationShape operation, OperationShape.Builder builder) {
        for (Shape remove : removed) {
            if (!remove.getId().equals(operation.getOutputShape())) continue;
            if (builder == null) {
                builder = operation.toBuilder();
            }
            builder.output(null);
            return builder;
        }
        return builder;
    }

    private OperationShape.Builder transformErrors(Collection<Shape> removed, OperationShape operation, OperationShape.Builder builder) {
        HashSet<ShapeId> errors = new HashSet<ShapeId>(operation.getErrors());
        for (Shape remove : removed) {
            errors.remove(remove.getId());
        }
        if (errors.size() != operation.getErrors().size()) {
            if (builder == null) {
                builder = operation.toBuilder();
            }
            builder.errors(errors);
            return builder;
        }
        return builder;
    }
}

