/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class FilterDeprecatedRelativeVersion {
    private static final Logger LOGGER = Logger.getLogger(FilterDeprecatedRelativeVersion.class.getName());
    private static final Pattern SEMVER_REGEX = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private final String relativeVersion;

    FilterDeprecatedRelativeVersion(String relativeVersion) {
        if (relativeVersion != null && !FilterDeprecatedRelativeVersion.isSemVer(relativeVersion)) {
            throw new IllegalArgumentException("Provided relativeDate: `" + relativeVersion + "` is not a valid .");
        }
        this.relativeVersion = relativeVersion;
    }

    Model transform(ModelTransformer transformer, Model model) {
        if (this.relativeVersion == null) {
            return model;
        }
        HashSet<Shape> shapesToRemove = new HashSet<Shape>();
        for (Shape shape : model.getShapesWithTrait(DeprecatedTrait.class)) {
            String since;
            Optional<String> sinceOptional = shape.expectTrait(DeprecatedTrait.class).getSince();
            if (!sinceOptional.isPresent() || !FilterDeprecatedRelativeVersion.isSemVer(since = sinceOptional.get()) || FilterDeprecatedRelativeVersion.compareSemVer(this.relativeVersion, since) <= 0) continue;
            LOGGER.fine("Filtering deprecated shape: `" + shape + "`. Shape was deprecated as of version: " + since);
            shapesToRemove.add(shape);
        }
        return transformer.removeShapes(model, shapesToRemove);
    }

    private static boolean isSemVer(String string) {
        return SEMVER_REGEX.matcher(string).matches();
    }

    static int compareSemVer(String semVer1, String semVer2) {
        String[] versionComponents1 = semVer1.split("\\.");
        String[] versionComponents2 = semVer2.split("\\.");
        int maxLength = Math.max(versionComponents1.length, versionComponents2.length);
        for (int i = 0; i < maxLength; ++i) {
            String component2;
            String component1 = i >= versionComponents1.length ? "0" : versionComponents1[i];
            int comparison = component1.compareTo(component2 = i >= versionComponents2.length ? "0" : versionComponents2[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }
}

