/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.node.BlobLengthPlugin;
import software.amazon.smithy.model.validation.node.CollectionLengthPlugin;
import software.amazon.smithy.model.validation.node.IdRefPlugin;
import software.amazon.smithy.model.validation.node.IntEnumPlugin;
import software.amazon.smithy.model.validation.node.MapLengthPlugin;
import software.amazon.smithy.model.validation.node.NonNumericFloatValuesPlugin;
import software.amazon.smithy.model.validation.node.PatternTraitPlugin;
import software.amazon.smithy.model.validation.node.RangeTraitPlugin;
import software.amazon.smithy.model.validation.node.StringEnumPlugin;
import software.amazon.smithy.model.validation.node.StringLengthPlugin;
import software.amazon.smithy.model.validation.node.UniqueItemsPlugin;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public interface NodeValidatorPlugin {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public void apply(Shape var1, Node var2, Context var3, Emitter var4);

    public static List<NodeValidatorPlugin> getBuiltins() {
        return ListUtils.of((Object[])new NodeValidatorPlugin[]{new NonNumericFloatValuesPlugin(), new BlobLengthPlugin(), new CollectionLengthPlugin(), new IdRefPlugin(), new MapLengthPlugin(), new PatternTraitPlugin(), new RangeTraitPlugin(), new StringEnumPlugin(), new IntEnumPlugin(), new StringLengthPlugin(), new UniqueItemsPlugin()});
    }

    @FunctionalInterface
    @SmithyInternalApi
    public static interface Emitter {
        public void accept(FromSourceLocation var1, Severity var2, String var3, String ... var4);

        default public void accept(FromSourceLocation sourceLocation, String message) {
            this.accept(sourceLocation, Severity.ERROR, message, EMPTY_STRING_ARRAY);
        }

        default public void accept(FromSourceLocation sourceLocation, Severity severity, String message) {
            this.accept(sourceLocation, severity, message, EMPTY_STRING_ARRAY);
        }
    }

    @SmithyInternalApi
    public static final class Context {
        private final Model model;
        private final Set<NodeValidationVisitor.Feature> features;
        private MemberShape referringMember;
        private final Map<Selector, Set<Shape>> selectorResults = new LinkedHashMap<Selector, Set<Shape>>(51, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<Selector, Set<Shape>> eldest) {
                return this.size() > 50;
            }
        };

        public Context(Model model) {
            this(model, Collections.emptySet());
        }

        public Context(Model model, Set<NodeValidationVisitor.Feature> features) {
            this.model = model;
            this.features = features;
        }

        public Model model() {
            return this.model;
        }

        public Set<Shape> select(Selector selector) {
            return this.selectorResults.computeIfAbsent(selector, s -> s.select(this.model));
        }

        public boolean hasFeature(NodeValidationVisitor.Feature feature) {
            return this.features.contains((Object)feature);
        }

        public void setReferringMember(MemberShape referringMember) {
            this.referringMember = referringMember;
        }

        public Optional<MemberShape> getReferringMember() {
            return Optional.ofNullable(this.referringMember);
        }
    }
}

